/*
 * Decompiled with CFR 0.152.
 */
package restarter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import restarter.Program;
import restarter.Settings;

public class Communicator {
    private static final Logger logger = Logger.getLogger(Communicator.class.getName());

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    public static String send(String location, String data, String method) throws IOException {
        String line;
        logger.info("send message: " + location + " with data: " + data + " and method: " + method);
        assert (method.equals("GET") || method.equals("POST")) : Settings.getText("ERRORMSG_UNSUPPORTEDCONNECTIONTYPE").replace("$method", method);
        URL url = new URL(location);
        String output = "";
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod(method);
        if (data.compareTo("") != 0) {
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
        }
        logger.info("try to connect to server");
        try {
            conn.connect();
        }
        catch (IOException e) {
            throw new UnknownHostException(e.getMessage());
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            output = String.valueOf(output) + "<" + line + "/>";
        }
        rd.close();
        logger.info("connection to server closed");
        return output;
    }
}

