/*
 * Decompiled with CFR 0.152.
 */
package restarter;

import java.io.File;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import restarter.PROGRAMFOLDERNAMES;
import restarter.Program;
import restarter.Registry;
import restarter.Settings;
import restarter.enums.OS;
import restarter.forms.BrowserPanel;

public class GetBrowsers
extends Thread {
    private static final Logger logger = Logger.getLogger(GetBrowsers.class.getName());
    private boolean[] browserFound = new boolean[5];
    private BrowserPanel browserPanel;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    private boolean BrowserExists(String file) {
        final File f = new File(file = file.toLowerCase());
        if (f.exists()) {
            if (file.endsWith("iexplore.exe")) {
                Settings.Default().bIExplorePath = file;
                if (this.browserPanel != null) {
                    logger.info("browser found: Internet Explorer");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GetBrowsers.this.browserPanel.getBIExplorer().setEnabled(true);
                            GetBrowsers.this.browserPanel.getBIExplorer().setToolTipText(f.toString());
                        }
                    });
                }
                this.browserFound[0] = true;
            } else if (file.endsWith("firefox.exe")) {
                logger.info("browser found: Mozilla Firefox");
                Settings.Default().bFirefoxPath = file;
                if (this.browserPanel != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GetBrowsers.this.browserPanel.getBFirefox().setEnabled(true);
                            GetBrowsers.this.browserPanel.getBFirefox().setToolTipText(f.toString());
                        }
                    });
                }
                this.browserFound[1] = true;
            } else if (file.endsWith("safari.exe")) {
                logger.info("browser found: Apple Safari");
                Settings.Default().bSafariPath = file;
                if (this.browserPanel != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GetBrowsers.this.browserPanel.getBSafari().setEnabled(true);
                            GetBrowsers.this.browserPanel.getBSafari().setToolTipText(f.toString());
                        }
                    });
                }
                this.browserFound[4] = true;
            } else if (file.endsWith("opera.exe")) {
                logger.info("browser found: Opera");
                Settings.Default().bOperaPath = file;
                if (this.browserPanel != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GetBrowsers.this.browserPanel.getBOpera().setEnabled(true);
                            GetBrowsers.this.browserPanel.getBOpera().setToolTipText(f.toString());
                        }
                    });
                }
                this.browserFound[2] = true;
            } else if (file.endsWith("chrome.exe")) {
                logger.info("browser found: Google Chrome");
                Settings.Default().bChromePath = file;
                System.out.print("Chrome found");
                if (this.browserPanel != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GetBrowsers.this.browserPanel.getBChrome().setEnabled(true);
                            GetBrowsers.this.browserPanel.getBChrome().setToolTipText(f.toString());
                        }
                    });
                }
                this.browserFound[3] = true;
            } else {
                return false;
            }
            if (this.browserFound[0] && this.browserFound[1] && this.browserFound[2] && this.browserFound[3] && this.browserFound[4]) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GetBrowsers.this.browserPanel.getBTopLabel().setText(Settings.getText("BROWSERPANEL_CHOOSEBROWSER"));
                    }
                });
            }
            return true;
        }
        return false;
    }

    private void SearchInStandardFolders() {
        if (this.browserFound[3] || this.BrowserExists(String.valueOf(Registry.getCurrentLocalAppDataFolderPath()) + "\\Google\\Chrome\\Application\\chrome.exe")) {
            // empty if block
        }
        PROGRAMFOLDERNAMES.Reset();
        do {
            char c = 'c';
            while (c < 'z') {
                if (this.browserFound[0] || this.BrowserExists(String.valueOf(c) + ":\\" + PROGRAMFOLDERNAMES.getCurrent() + "\\Internet Explorer\\iexplore.exe")) {
                    // empty if block
                }
                if (this.browserFound[1] || this.BrowserExists(String.valueOf(c) + ":\\" + PROGRAMFOLDERNAMES.getCurrent() + "\\Mozilla Firefox\\firefox.exe")) {
                    // empty if block
                }
                if (this.browserFound[2] || this.BrowserExists(String.valueOf(c) + ":\\" + PROGRAMFOLDERNAMES.getCurrent() + "\\Opera\\opera.exe")) {
                    // empty if block
                }
                if (this.browserFound[3] || this.BrowserExists(String.valueOf(c) + ":\\" + PROGRAMFOLDERNAMES.getCurrent() + "\\Google Chrome\\chrome")) {
                    // empty if block
                }
                if (this.browserFound[4] || this.BrowserExists(String.valueOf(c) + ":\\" + PROGRAMFOLDERNAMES.getCurrent() + "\\Safari\\safari.exe")) {
                    // empty if block
                }
                c = (char)(c + '\u0001');
            }
        } while (PROGRAMFOLDERNAMES.goToNext());
    }

    private void ExtendedSearch(String Path2) {
        try {
            File f = new File(Path2);
            if (!f.exists()) {
                return;
            }
            if (!this.browserFound[0] && Path2.endsWith("iexplore.exe")) {
                this.BrowserExists(Path2);
            } else if (!this.browserFound[1] && Path2.endsWith("firefox.exe")) {
                this.BrowserExists(Path2);
            } else if (!this.browserFound[2] && Path2.endsWith("opera.exe")) {
                this.BrowserExists(Path2);
            } else if (!this.browserFound[3] && Path2.endsWith("chrome.exe")) {
                this.BrowserExists(Path2);
            } else if (!this.browserFound[4] && Path2.endsWith("safari.exe")) {
                this.BrowserExists(Path2);
            }
            File[] files = f.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.ExtendedSearch(file.getAbsolutePath());
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(e.getMessage()) + " at " + e.getStackTrace());
        }
    }

    private void ExtendedSearch() {
        File[] roots;
        File[] fileArray = roots = File.listRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            File root = fileArray[n2];
            this.ExtendedSearch(root.getAbsolutePath());
            ++n2;
        }
    }

    public void SetSettingsWindow(BrowserPanel panel) {
        this.browserPanel = panel;
    }

    public void RemoveSettingsWindow() {
        this.browserPanel = null;
    }

    public GetBrowsers(boolean[] searchFor) {
        this.browserFound = searchFor;
    }

    @Override
    public void run() {
        if (Settings.Default().OperatingSystem() != OS.WINDOWS) {
            return;
        }
        this.SearchInStandardFolders();
        if (!(this.browserFound[0] && this.browserFound[1] && this.browserFound[1] && this.browserFound[2] && this.browserFound[3] && !this.browserFound[4])) {
            this.ExtendedSearch();
        }
    }
}

