/*
 * Decompiled with CFR 0.152.
 */
package restarter;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import restarter.Program;
import restarter.Settings;
import restarter.ViewComponent;

public abstract class PopUp
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4714L;
    private Timer timer;
    protected GridBagLayout layout;
    private JLabel top;
    protected JTextArea text;
    protected JButton cancelButton;
    private ViewComponent back;

    public PopUp(JFrame owner, String text, String buttonText, int timerDelay) {
        super(owner, "eBesucher Restarter", false);
        this.Initialize(text, buttonText);
        if (timerDelay > 0) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    PopUp.this.doOnTimerDelay();
                }
            }, timerDelay);
        }
    }

    public void CloseWindow() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public abstract void doOnTimerDelay();

    public void SetButtonText(String text) {
        this.text.setText(text);
    }

    private void Initialize(String text2, String buttonText) {
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        GridBagConstraints cons = new GridBagConstraints();
        this.top = new JLabel(Settings.Default().ProductName);
        this.top.setFont(new Font("Arial", 1, 16));
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 2;
        cons.gridheight = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.insets = new Insets(8, 4, 2, 4);
        this.layout.setConstraints(this.top, cons);
        this.add(this.top);
        this.text = new JTextArea(text2);
        this.text.setEditable(false);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setOpaque(false);
        this.text.setFont(new Font("Arial", 0, 11));
        cons.gridx = 0;
        cons.gridy = 1;
        cons.weighty = 1.0;
        cons.gridheight = 1;
        cons.insets = new Insets(1, 4, 1, 80);
        this.layout.setConstraints(this.text, cons);
        this.add(this.text);
        this.cancelButton = new JButton(buttonText);
        this.cancelButton.setActionCommand("button1");
        this.cancelButton.addActionListener(this);
        cons.insets = new Insets(0, 16, 4, 16);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.gridwidth = 2;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.anchor = 10;
        cons.fill = 0;
        this.layout.setConstraints(this.cancelButton, cons);
        this.add(this.cancelButton);
        this.back = new ViewComponent("PopUpBack.png", null);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridheight = 3;
        cons.gridwidth = 2;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.anchor = 10;
        cons.fill = 1;
        this.layout.setConstraints(this.back, cons);
        this.add(this.back);
        this.setUndecorated(true);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maximumWindowBounds = graphicsEnvironment.getMaximumWindowBounds();
        this.setBounds(maximumWindowBounds.width - 280, maximumWindowBounds.height - 140, 280, 140);
        this.setAlwaysOnTop(true);
        this.setVisible(Settings.Default().showPopUp);
    }

    class BackGroundPane
    extends JPanel {
        private static final long serialVersionUID = 4714L;
        Image img = null;

        BackGroundPane(String imagefile) {
            if (imagefile != null) {
                MediaTracker mt = new MediaTracker(this);
                this.img = Toolkit.getDefaultToolkit().getImage(Program.class.getResource(imagefile));
                mt.addImage(this.img, 0);
                try {
                    mt.waitForAll();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.img, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }
}

