/*
 * Decompiled with CFR 0.152.
 */
package restarter;

import java.awt.Robot;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import restarter.KeyValue;
import restarter.PopUp;
import restarter.Program;
import restarter.ServerWork;
import restarter.Settings;
import restarter.Task;
import restarter.enums.OS;
import restarter.enums.RunningStates;

public class PopUpTimerTask
extends TimerTask {
    private static final Logger logger = Logger.getLogger(PopUpTimerTask.class.getName());
    private PopUp popUp;
    private int time = 15;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    public PopUpTimerTask(PopUp popUp) {
        this.popUp = popUp;
    }

    @Override
    public void run() {
        block30: {
            --this.time;
            if (this.time > 5) {
                if (Settings.Default().restartBrowser) {
                    Program.menuForm.counterLabel.setText(Settings.getText("RESTART_RESTARTINSEC").replace("$time", String.valueOf(this.time)));
                } else {
                    logger.info("restart browser is disabled");
                }
            } else if (this.time > 0) {
                if (Settings.Default().restartBrowser) {
                    this.popUp.SetButtonText(String.valueOf(Settings.getText("RESTART_RESTART")) + "\n" + Settings.getText("RESTART_CLOSEBROWSER"));
                    Program.menuForm.counterLabel.setText(Settings.getText("RESTART_RESTARTINSEC").replace("$time", String.valueOf(this.time)));
                }
            } else if (this.time == 0) {
                try {
                    if (!Task.check(ServerWork.GetResponse()) || KeyValue.getValue(Task.getLastResponce(), "Timeout_reached").equals("true")) {
                        Program.menuForm.SetProgramWorkState(RunningStates.RESTARTING);
                        if (!Settings.Default().restartBrowser) {
                            this.time = -5 - Settings.Default().TimeToEmulateEnter;
                            logger.info("start browser: " + Settings.Default().getBrowserFile());
                        } else {
                            Program.menuForm.counterLabel.setText(String.valueOf(Settings.getText("RESTART_CLOSEBROWSER")) + "...");
                            this.popUp.SetButtonText(String.valueOf(Settings.getText("RESTART_RESTART")) + "\n" + Settings.getText("RESTART_STARTBROWSER"));
                            this.KillBrowser();
                        }
                        break block30;
                    }
                    this.popUp.CloseWindow();
                    Task.timer.cancel();
                    Program.StartTimer(Settings.Default().timerDelay);
                    logger.info("no problems found: restart counter");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.popUp.CloseWindow();
                    Task.timer.cancel();
                    Program.StartTimer(Settings.Default().timerDelay);
                    Program.menuForm.SetProgramWorkState(RunningStates.NOCONNECTION);
                    logger.severe("cound not restart browser: " + e.getMessage());
                }
            } else if (this.time == -5) {
                if (Settings.Default().emulateEnter) {
                    this.popUp.SetButtonText(String.valueOf(Settings.getText("RESTART_RESTART")) + "\n" + Settings.getText("RESTART_EMULATEENTER"));
                }
                Program.menuForm.counterLabel.setText(Settings.getText("RESTART_STARTBROWSER"));
                switch (Settings.Default().BrowserStartOption) {
                    case START_WITHOUT_LINK: {
                        PopUpTimerTask.StartBrowser(false);
                        Settings.Default().BrowserStartOption = Settings.StartOptions.RESTARTED;
                        break;
                    }
                }
            } else if (this.time == -8) {
                if (!Settings.Default().emulateEnter) {
                    this.time = -5 - Settings.Default().TimeToEmulateEnter;
                }
            } else if (this.time == -5 - Settings.Default().TimeToEmulateEnter) {
                if (Settings.Default().emulateEnter) {
                    this.PressEnter();
                } else {
                    logger.info("emulate enter is disabled");
                }
            } else if (this.time == -6 - Settings.Default().TimeToEmulateEnter) {
                this.popUp.CloseWindow();
                if (Settings.Default().restartBrowser) {
                    Program.StartTimer(30);
                } else {
                    Program.StartTimer(Settings.Default().timerDelay);
                }
                logger.info("restarting successful");
            }
        }
    }

    private void KillBrowser() {
        String browserFile;
        if (Settings.Default().getBrowserFile() == null) {
            logger.severe("closing browser failed. no browser definied!");
            return;
        }
        switch (Settings.Default().OperatingSystem()) {
            case WINDOWS: {
                browserFile = Settings.Default().getBrowserFile().substring(Settings.Default().getBrowserFile().lastIndexOf("\\") + 1);
                break;
            }
            default: {
                browserFile = Settings.Default().getBrowserFile();
            }
        }
        try {
            String command = String.format(Settings.Default().getCloseBrowserCommand(), browserFile);
            Process proc = Runtime.getRuntime().exec(command);
            logger.info("browser close result: " + proc.waitFor() + " [command: " + command + "]");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.popUp, Settings.getText("RESTART_CANTUSEPSKILL"), Settings.getText("ERROR"), 0);
            logger.severe("closing browser failed: " + exception.getMessage());
        }
    }

    public static void StartBrowser(String url) {
        if (Settings.Default().getBrowserFile() == null) {
            logger.severe("closing browser failed. no browser definied!");
            return;
        }
        String command = "unbekannt";
        if (Settings.Default().OperatingSystem() == OS.WINDOWS) {
            try {
                command = "rundll32 url.dll,FileProtocolHandler " + url;
                Runtime.getRuntime().exec(command);
                logger.info("start browser with url: " + url + " [command: " + command + "]");
            }
            catch (Exception exception) {
                logger.severe("opening browser failed [command=" + command + ", message=" + exception.getMessage() + "]");
            }
        } else if (Settings.Default().OperatingSystem() == OS.MAC) {
            try {
                command = "open -a " + Settings.Default().getBrowserFile() + " " + url;
                Runtime.getRuntime().exec(command);
                logger.info("start browser with url: " + url + " [command: " + command + "]");
            }
            catch (Exception exception) {
                logger.severe("opening browser failed [command=" + command + ", message=" + exception.getMessage() + "]");
            }
        } else if (Settings.Default().OperatingSystem() == OS.LINUX) {
            try {
                String arg = Settings.Default().getBrowserFile().contains("firefox") ? Settings.Default().NewTabArgFireFox : (Settings.Default().getBrowserFile().contains("chrome") ? Settings.Default().NewTabArgChrome : (Settings.Default().getBrowserFile().contains("opera") ? Settings.Default().NewTabArgOpera : (Settings.Default().getBrowserFile().contains("iexplore") ? Settings.Default().NewTabArgIE : Settings.Default().NewTabArgOthers)));
                command = String.valueOf(Settings.Default().getBrowserFile()) + " " + arg + " " + url;
                Runtime.getRuntime().exec(command);
                logger.info("start browser with url: " + url + " [command: " + command + "]");
            }
            catch (Exception exception) {
                logger.severe("opening browser failed [command=" + command + ", message=" + exception.getMessage() + "]");
            }
        }
    }

    public static void StartBrowser(boolean withLink) {
        String url = Settings.Default().getSurfbarLink();
        String command = "unbekannt";
        if (Settings.Default().OperatingSystem() == OS.WINDOWS) {
            try {
                command = withLink ? String.valueOf(Settings.Default().getBrowserFile()) + " " + url : Settings.Default().getBrowserFile();
                Runtime.getRuntime().exec(command);
                logger.info("start browser with url: " + url + " [command: " + command + "]");
            }
            catch (Exception exception) {
                logger.severe("opening browser failed [command=" + command + ", message=" + exception.getMessage() + "]");
            }
        } else if (Settings.Default().OperatingSystem() == OS.MAC) {
            try {
                if (Settings.Default().getBrowserFile() == null) {
                    logger.severe("opening browser failed. no browser definied!");
                    return;
                }
                command = withLink ? "open -a " + Settings.Default().getBrowserFile() + " " + url : "open -a " + Settings.Default().getBrowserFile();
                Runtime.getRuntime().exec(command);
                logger.info("start browser with url: " + url + " [command: " + command + "]");
            }
            catch (Exception exception) {
                logger.severe("opening browser failed [command=" + command + ", message=" + exception.getMessage() + "]");
            }
        } else {
            try {
                if (Settings.Default().getBrowserFile() == null) {
                    logger.severe("opening browser failed. no browser definied!");
                    return;
                }
                command = withLink ? String.valueOf(Settings.Default().getBrowserFile()) + " -new-tab " + url : Settings.Default().getBrowserFile();
                Runtime.getRuntime().exec(command);
                logger.info("start browser with url: " + url + " [command: " + command + "]");
            }
            catch (Exception exception) {
                logger.severe("opening browser failed [command=" + command + ", message=" + exception.getMessage() + "]");
            }
        }
    }

    private void PressEnter() {
        try {
            Robot rob = new Robot();
            rob.keyPress(10);
            rob.keyRelease(10);
            logger.info("pressed enter");
        }
        catch (Exception e) {
            logger.severe("emulate enter failed: " + e.getMessage());
        }
    }
}

