/*
 * Decompiled with CFR 0.152.
 */
package restarter;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import restarter.Settings;
import restarter.Task;
import restarter.Tray;
import restarter.enums.OS;
import restarter.enums.RunningStates;
import restarter.forms.MenuForm;
import restarter.forms.WelcomeForm;

public class Program {
    private static Logger logger = Logger.getLogger(Program.class.getName());
    public static FileHandler fh;
    private static Timer workTimer;
    private static boolean isWorking;
    private static Tray tray;
    public static MenuForm menuForm;
    public static boolean useTray;
    public static Image programImage;
    public static int nextCheckCounter;
    public static RunningStates runningState;

    static {
        isWorking = false;
        useTray = true;
        nextCheckCounter = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int i;
        StackTraceElement[] trace;
        String message;
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].startsWith("-LogFolder:")) {
                String logpath = args[i2].substring("-LogFolder:".length());
                if (!new File(logpath).exists()) break;
                if (!logpath.endsWith("\\") || !logpath.endsWith("/")) {
                    logpath = String.valueOf(logpath) + "/";
                }
                try {
                    String path = String.valueOf(logpath) + "restarter.log";
                    fh = new FileHandler(path, false);
                    logger.addHandler(fh);
                    Logger.getLogger(Settings.class.getName()).addHandler(fh);
                    logger.setLevel(Level.INFO);
                    SimpleFormatter formatter = new SimpleFormatter();
                    fh.setFormatter(formatter);
                    logger.log(Level.INFO, "logger initialized...");
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            ++i2;
        }
        logger.log(Level.INFO, "program start");
        try {
            Settings.Default().init();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
            return;
        }
        logger.log(Level.INFO, "settings path detected: " + Settings.SettingsPath);
        logger.info("operating system detected: " + (Object)((Object)Settings.Default().OperatingSystem()));
        if (!Settings.Default().useSunJava) {
            String text;
            logger.log(Level.SEVERE, "unsupported java version detected");
            switch (Settings.Default().OperatingSystem()) {
                case WINDOWS: {
                    text = Settings.getText("ERRORMSG_UNSUPPORTED_JDK_MESSAGE_TEXT");
                    text = String.valueOf(text) + "\n" + Settings.Default().getJavaVersion() + "\n" + Settings.getText("ERRORMSG_UNSUPPORTED_JDK_MESSAGE_INSTALL_WIN");
                    break;
                }
                case MAC: {
                    text = Settings.getText("ERRORMSG_UNSUPPORTED_JDK_MESSAGE_TEXT");
                    text = String.valueOf(text) + "\n" + Settings.Default().getJavaVersion() + "\n" + Settings.getText("ERRORMSG_UNSUPPORTED_JDK_MESSAGE_INSTALL_MAC");
                    break;
                }
                default: {
                    text = Settings.getText("ERRORMSG_UNSUPPORTED_JDK_MESSAGE_TEXT");
                    text = String.valueOf(text) + "\n" + Settings.Default().getJavaVersion() + "\n" + Settings.getText("ERRORMSG_UNSUPPORTED_JDK_MESSAGE_INSTALL_LIN");
                }
            }
            logger.log(Level.INFO, text);
            logger.log(Level.INFO, "close program");
            return;
        }
        String errorMsg = Program.checkJavaVersion();
        if (errorMsg != null) {
            logger.warning("Java Version is less than 1.6.0_29. The programm may run not correctly");
            JOptionPane.showMessageDialog(null, errorMsg, "", 0);
        }
        try {
            boolean donotshowwelcome = false;
            boolean showWelcome = false;
            int i3 = 0;
            while (true) {
                if (i3 >= args.length) {
                    try {
                        programImage = Toolkit.getDefaultToolkit().getImage(Program.class.getResource("favicon.png"));
                        logger.log(Level.INFO, "loading program icon succeed");
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "loading program icon failed: \n" + e.getMessage());
                    }
                    break;
                }
                if (args[i3].equals("-notray")) {
                    logger.log(Level.INFO, "using tray disabled");
                    useTray = false;
                } else if (args[i3].equals("-showwelcome")) {
                    logger.log(Level.INFO, "open welcome window");
                    showWelcome = true;
                } else if (args[i3].equals("-nowelcome")) {
                    logger.log(Level.INFO, "skip welcome window");
                    donotshowwelcome = true;
                } else {
                    if (args[i3].equals("-getcommands")) {
                        logger.log(Level.INFO, "show all commands");
                        System.out.println(String.valueOf(Settings.Default().ProductName) + " Version: " + Settings.Default().VersionNumber);
                        System.out.println("Available commands are:");
                        System.out.println("\t\"-notray\": no tray will create");
                        System.out.println("\t\"-showwelcome\": the welcome form will show on startup");
                        System.out.println("\t\"-timer:\": set the restart time delay");
                        System.out.println("\t\"-settingspath:\": set the path where saving the configuration");
                        System.out.println("Program running canceled...");
                        return;
                    }
                    if (args[i3].startsWith("-timer:")) {
                        try {
                            Settings.Default().timerDelay = Settings.Default().RestartInterval = Integer.parseInt(args[i3].substring(6));
                            logger.log(Level.INFO, "timer set to " + Settings.Default().timerDelay);
                        }
                        catch (Exception e) {
                            Settings.Default().timerDelay = Settings.Default().RestartInterval;
                            logger.log(Level.WARNING, "timer could not set: setting to default");
                        }
                    } else if (args[i3].equals("-windows")) {
                        Settings.Default().SetOperatingSystem(OS.WINDOWS);
                        logger.log(Level.INFO, "start in mode for Windows");
                    } else if (args[i3].startsWith("-settingspath:")) {
                        Settings.SettingsPath = args[i3].substring("-settingspath:".length()).trim();
                        logger.info("Settings path set to " + Settings.SettingsPath);
                    } else {
                        logger.log(Level.WARNING, "unknown command: " + args[i3] + "\nUse \"-getcommands\" for available commands.");
                    }
                }
                ++i3;
            }
            Settings.Default().LoadLanguageFile();
            File f = new File(String.valueOf(Settings.SettingsPath) + "data.ini");
            if (!(donotshowwelcome || !showWelcome && f.exists())) {
                logger.log(Level.INFO, "open welcome window");
                try {
                    boolean[] searchFor = new boolean[5];
                    Settings.Default().searchForBrowsers(searchFor);
                    Settings.Default().LoadLanguageFile();
                    new WelcomeForm(null);
                    if (WelcomeForm.RESULT != 0) return;
                    Program.BeginWork();
                    return;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, String.valueOf(Settings.Default().Language.getProperty("ERRORMSG_INITIALIZINGWELCOME")) + "\n" + e.getMessage(), "Fatal error", 0);
                    return;
                }
            }
            Settings.Default().LoadData();
            Program.BeginWork();
            return;
        }
        catch (Exception e) {
            message = "Leider ist ein Problem beim Starten des Programmes aufgetreten.\n";
            message = String.valueOf(message) + e.toString() + "\n";
            trace = e.getStackTrace();
            i = 0;
        }
        while (true) {
            if (i >= trace.length) {
                JTextArea text = new JTextArea(message);
                JOptionPane.showMessageDialog(null, text, "Fehler beim Starten", 0);
                logger.log(Level.SEVERE, "error on starting program.\nmessage:\n" + e.getMessage());
                return;
            }
            message = String.valueOf(message) + "\tat " + trace[i] + "\n";
            ++i;
        }
    }

    private static String checkJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        logger.info("Check for Java Version. Installed: " + javaVersion);
        if (javaVersion.charAt(0) < '1') {
            return String.valueOf(Settings.getText("ERRORMSG_JAVAUPDATE")) + " [Version: " + javaVersion + "]";
        }
        if (javaVersion.charAt(2) == '1' && javaVersion.charAt(2) < '6') {
            return String.valueOf(Settings.getText("ERRORMSG_JAVAUPDATE")) + " [Version: " + javaVersion + "]";
        }
        if (javaVersion.charAt(2) == '6' && Integer.parseInt(javaVersion.substring(6)) < 29) {
            return String.valueOf(Settings.getText("ERRORMSG_JAVAUPDATE")) + " [Version: " + javaVersion + "]";
        }
        return null;
    }

    public static void BeginWork() {
        if (!isWorking) {
            logger.log(Level.INFO, "start watching surfbar");
            if (Settings.Default().OperatingSystem() == OS.MAC) {
                useTray = false;
            }
            if (useTray) {
                try {
                    tray = new Tray();
                    logger.log(Level.INFO, "create tray");
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    useTray = false;
                    logger.log(Level.WARNING, "creating tray failed");
                }
            }
            if (!useTray) {
                logger.log(Level.INFO, "tray is disabled");
                tray = null;
            }
            logger.log(Level.INFO, "create work timer");
            workTimer = new Timer();
            menuForm = new MenuForm(Settings.Default().menuFormLeft, Settings.Default().menuFormTop);
        }
        if (Settings.Default().autoStart) {
            logger.log(Level.INFO, "auto start enabled: start watching surfbar");
            Program.StartTimer(30);
        }
    }

    public static void StopTimer() {
        logger.log(Level.INFO, "stop watching surfbar");
        workTimer.cancel();
        if (tray != null) {
            tray.setName(String.valueOf(Settings.Default().ProductName) + " (" + Settings.Default().Language.getProperty("TAG_STOPPED") + ")");
            Program.tray.trayMenu.getItem(0).setLabel(Settings.Default().Language.getProperty("TAG_START"));
        }
        isWorking = false;
    }

    public static void StartTimer(int counter) {
        logger.log(Level.INFO, "start watch timer");
        nextCheckCounter = counter;
        Program.menuForm.counterLabel.setText(Settings.Default().Language.getProperty("TAG_CHECKINSECONDS").replace("$counter", String.valueOf(counter)));
        workTimer = new Timer();
        workTimer.schedule((TimerTask)new Task(), 1000L, 1000L);
        if (tray != null) {
            tray.setName(Settings.Default().ProductName);
            Program.tray.trayMenu.getItem(0).setLabel(Settings.Default().Language.getProperty("TAG_STOP"));
        }
        isWorking = true;
        menuForm.SetProgramWorkState(RunningStates.RUNNING);
    }

    public static boolean isWorking() {
        return isWorking;
    }
}

