/*
 * Decompiled with CFR 0.152.
 */
package restarter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import restarter.forms.OptionsForm;

public class PropertiesLoader {
    public static Properties loadProperties(InputStream is) throws IOException {
        return PropertiesLoader.loadProperties(is, "unicode");
    }

    public static Properties loadProperties(InputStream is, String encoding) throws IOException {
        int temp;
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(is, encoding);
        int i = 25;
        while ((temp = isr.read()) >= 0) {
            char c = (char)temp;
            sb.append(c);
            OptionsForm.setSaveState(i);
            if (i >= 80) continue;
            ++i;
        }
        String inputString = PropertiesLoader.escapifyStr(sb.toString());
        byte[] bs = inputString.getBytes("ISO-8859-1");
        ByteArrayInputStream bais = new ByteArrayInputStream(bs);
        OptionsForm.setSaveState(82);
        Properties ps = new Properties();
        ps.load(bais);
        OptionsForm.setSaveState(95);
        return ps;
    }

    private static char hexDigit(char ch, int offset) {
        int val = ch >> offset & 0xF;
        if (val <= 9) {
            return (char)(48 + val);
        }
        return (char)(65 + val - 10);
    }

    private static String escapifyStr(String str) {
        StringBuilder result = new StringBuilder();
        int len = str.length();
        int x = 0;
        while (x < len) {
            char ch = str.charAt(x);
            if (ch <= '~') {
                result.append(ch);
            } else {
                result.append('\\');
                result.append('u');
                result.append(PropertiesLoader.hexDigit(ch, 12));
                result.append(PropertiesLoader.hexDigit(ch, 8));
                result.append(PropertiesLoader.hexDigit(ch, 4));
                result.append(PropertiesLoader.hexDigit(ch, 0));
            }
            ++x;
        }
        return result.toString();
    }
}

