/*
 * Decompiled with CFR 0.152.
 */
package restarter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import restarter.GetBrowsers;
import restarter.Program;
import restarter.PropertiesLoader;
import restarter.Registry;
import restarter.enums.OS;
import restarter.forms.InfoPopUp;
import restarter.forms.OptionsForm;
import restarter.forms.SelectOSForm;

public class Settings {
    private static final Logger logger = Logger.getLogger(Settings.class.getName());
    public static final String CreditsText = "\u00a9 eBesucher.de 2010 - 2011";
    public static String SettingsPath;
    public static String ProgramPath;
    private static Settings instance;
    public String language = null;
    private String browserFile = "firefox";
    public boolean alwaysOnTop = false;
    public boolean hideMenuForm = false;
    public boolean autoStart = true;
    public int timerDelay = 60;
    private String user;
    private String password;
    private OS currentOS;
    public boolean showLogInForm;
    public int menuFormLeft;
    public int menuFormTop;
    public boolean showPopUp = true;
    public boolean restartBrowser = true;
    public boolean startWithLink;
    public boolean emulateEnter = true;
    public boolean showStatePicture = true;
    public final String ProductName = "Restarter";
    public final String VersionNumber = "1.2.03";
    public int TimeToEmulateEnter = 15;
    public Properties Language;
    public StartOptions BrowserStartOption = StartOptions.START_WITHOUT_LINK;
    public String bIExplorePath = "n/A";
    public String bFirefoxPath = "n/A";
    public String bChromePath = "n/A";
    public String bSafariPath = "n/A";
    public String bOperaPath = "n/A";
    public String bOtherPath = "n/A";
    public String NewTabArgIE = "-newtab";
    public String NewTabArgFireFox = "";
    public String NewTabArgSafari = "";
    public String NewTabArgOpera = "-newtab";
    public String NewTabArgChrome = "-new-tab";
    public String NewTabArgOthers = "-new-tab";
    public boolean useSunJava = true;
    public String Domain = "ebesucher";
    public String[] TopLevelDomains = new String[]{"de", "com", "ru"};
    private String topLevelDomain = "de";
    public String SurfbarLink = "surfbar/";
    public int RestartFailures = -1;
    public GetBrowsers getBrowsers;
    public int DuplicateRestarterTimeAfterTries = 5;
    public int MaxRestartTimeInSeconds = 3600;
    public int RestartInterval = 60;
    private String closeBrowserCommand;
    private String startBrowserCommand;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
        SettingsPath = null;
        ProgramPath = String.valueOf(new File("").getAbsolutePath()) + "/";
        instance = new Settings();
    }

    public static Settings Default() {
        return instance;
    }

    public static String getText(String tag) {
        String s;
        if (Settings.instance.Language == null) {
            instance.LoadLanguageFile();
        }
        if ((s = Settings.instance.Language.getProperty(tag)) == null) {
            logger.warning("language tag not found: " + tag);
            return tag;
        }
        return s;
    }

    private Settings() {
    }

    public void init() throws Exception {
        logger.info("initialize");
        this.getOS();
        this.getSettingsPath();
        try {
            ProcessBuilder pb = new ProcessBuilder("java", "-version");
            Process proc = pb.start();
            if (proc.waitFor() == 0) {
                if (!this.lookForJavaType(proc.getInputStream()) && !this.lookForJavaType(proc.getErrorStream())) {
                    this.useSunJava = false;
                    logger.severe("no sun java found");
                }
            } else {
                this.useSunJava = false;
                logger.severe("no sun java found");
            }
        }
        catch (IOException e) {
            this.useSunJava = false;
            logger.severe("no sun java found: " + e.getMessage());
        }
        catch (InterruptedException e) {
            this.useSunJava = false;
            logger.severe("no sun java found: " + e.getMessage());
        }
        if (this.useSunJava) {
            logger.info("sun java found");
        }
    }

    protected void finalize() {
        this.SaveData();
    }

    public String getBrowserFile() {
        if (this.browserFile == null) {
            new OptionsForm(Program.menuForm);
            return "";
        }
        if (this.OperatingSystem() == OS.WINDOWS) {
            if (this.browserFile.toLowerCase().equals("iexplore")) {
                return this.bIExplorePath;
            }
            if (this.browserFile.toLowerCase().equals("firefox")) {
                return this.bFirefoxPath;
            }
            if (this.browserFile.toLowerCase().equals("chrome")) {
                return this.bChromePath;
            }
            if (this.browserFile.toLowerCase().equals("safari")) {
                return this.bSafariPath;
            }
            if (this.browserFile.toLowerCase().equals("opera")) {
                return this.bOperaPath;
            }
            return this.browserFile;
        }
        return this.browserFile;
    }

    public String getDefaultTopLevelDomain() {
        String[] stringArray = this.TopLevelDomains;
        int n = this.TopLevelDomains.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            if (lang.equals(this.language)) {
                return lang;
            }
            ++n2;
        }
        return "com";
    }

    public String getJavaVersion() {
        ProcessBuilder pb = new ProcessBuilder("java", "-version");
        try {
            Process proc = pb.start();
            if (proc.waitFor() == 0) {
                String s = this.getJavaVersion(proc.getInputStream());
                if (s.length() > 0) {
                    return s;
                }
                s = this.getJavaVersion(proc.getErrorStream());
                if (s.length() > 0) {
                    return s;
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Settings.getText("TAG_UNKNOWN");
    }

    private String getJavaVersion(InputStream error) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        while ((c = error.read()) != -1) {
            buf.append((char)c);
        }
        error.close();
        String s = buf.toString();
        return s;
    }

    private void getOS() {
        String os = System.getProperties().getProperty("os.name");
        if (os.contains("Windows")) {
            this.currentOS = OS.WINDOWS;
        } else if (os.contains("Linux") || os.contains("SunOS")) {
            this.currentOS = OS.LINUX;
        } else if (os.contains("Mac")) {
            this.currentOS = OS.MAC;
        } else {
            this.currentOS = null;
            return;
        }
        logger.info("operating system: " + (Object)((Object)this.currentOS));
    }

    public String getPassword() {
        return this.password;
    }

    private void getSettingsPath() throws Exception {
        if (SettingsPath != null) {
            logger.info("settings path allready specified. detecting aborted");
            return;
        }
        if (this.currentOS == OS.WINDOWS) {
            File path;
            logger.log(Level.INFO, "operating system detected: Windows");
            String appDataFolder = System.getenv("LOCALAPPDATA");
            if (appDataFolder == null || !new File(appDataFolder).exists()) {
                logger.log(Level.INFO, "home directory not found via Try System.getenv(\"LOCALAPPDATA\")). Try System.getenv(\"APPDATA\").");
                appDataFolder = System.getenv("APPDATA");
            }
            if (appDataFolder == null || !new File(appDataFolder).exists()) {
                logger.log(Level.INFO, "home directory not found via System.getenv(\"LOCALAPPDATA\"). Try to get from registry.");
                appDataFolder = Registry.getCurrentLocalAppDataFolderPath();
            }
            if (appDataFolder == null || !new File(appDataFolder).exists()) {
                logger.log(Level.WARNING, "detecting local application data folder failed.");
                if (new File("C:\\eBesucher\\data.ini").exists()) {
                    logger.log(Level.INFO, "settings path set to C:\\eBesucher\\");
                    SettingsPath = "C:\\eBesucher\\";
                } else if (JOptionPane.showConfirmDialog(null, String.valueOf(Settings.getText("ERRORMSG_SAVINGPATHDONTEXIST")) + "\n" + "\n" + Settings.getText("ERRORMSG_ERROROCCURED") + "\n" + (appDataFolder == null ? String.valueOf(Settings.getText("ERRORMSG_NOREGISTRYACCESS")) + "\n\n" : String.valueOf(Settings.getText("ERRORMSG_PATHDONTEXIST").replace("$PATH", appDataFolder)) + "\n\n") + Settings.getText("ERRORMSG_ALTERNATIVEPATH").replace("$PATH", "C:\\eBesucher\\") + "\n\n" + Settings.getText("ERRORMSG_SUPPORT") + "\nsupport@ebesucher.de\n" + Settings.getText("ERRORMSG_SUPPORT2"), Settings.getText("ERROR"), 0, 0) == 0) {
                    File f = new File("C:\\eBesucher\\");
                    try {
                        f.mkdir();
                        SettingsPath = "C:\\eBesucher\\";
                        logger.log(Level.INFO, "created folder and set settings path to C:\\eBesucher\\");
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, Settings.getText("ERRORMSG_CANNOTWRITETOC"), Settings.getText("ERRORMSG_NOWRITEACCED"), 0);
                        logger.log(Level.SEVERE, "can't create folder C:\\eBesucher\\");
                        return;
                    }
                } else {
                    throw new Exception("creating folder denied by user. Close program.");
                }
            }
            if (!(path = new File(SettingsPath = String.valueOf(appDataFolder) + "\\ebesucher\\restarter\\")).exists()) {
                logger.log(Level.INFO, "make directories: " + path);
                path.mkdirs();
            }
        } else {
            SettingsPath = "./";
        }
    }

    public String getSurfbarLink() {
        if (this.getTopLevelDomain() == null) {
            this.setTopLevelDomain(this.getDefaultTopLevelDomain());
        }
        String result = "http://www." + this.Domain + "." + this.getTopLevelDomain() + "/" + this.SurfbarLink;
        if (this.getUser() != null) {
            result = String.valueOf(result) + this.getUser();
        }
        logger.info("creating surfbar link: " + result);
        return result;
    }

    public String getTopLevelDomain() {
        return this.topLevelDomain;
    }

    public String getUser() {
        return this.user;
    }

    public String getWebAdress() {
        if (this.getTopLevelDomain() == null) {
            this.setTopLevelDomain(this.getDefaultTopLevelDomain());
        }
        String result = "http://www." + this.Domain + "." + this.getTopLevelDomain() + "/";
        logger.info("creating ebesucher link: " + result);
        return result;
    }

    public void LoadData() {
        File file = new File(String.valueOf(SettingsPath) + "data.ini");
        if (file.exists()) {
            try {
                Properties prop = new Properties();
                FileInputStream fis = new FileInputStream(String.valueOf(SettingsPath) + "data.ini");
                prop.load(fis);
                fis.close();
                this.SetAccount(prop.getProperty("user"), prop.getProperty("password"));
                this.alwaysOnTop = prop.getProperty("alwaysOnTop").equals("true");
                this.hideMenuForm = prop.getProperty("hideMenuForm").equals("true");
                this.menuFormLeft = Integer.parseInt(prop.getProperty("menuFormLeft"));
                this.menuFormTop = Integer.parseInt(prop.getProperty("menuFormTop"));
                this.browserFile = prop.getProperty("Browser");
                this.showPopUp = prop.getProperty("showPopUp").equals("true");
                this.restartBrowser = prop.getProperty("restartBrowser").equals("true");
                this.startWithLink = prop.getProperty("startWithLink").equals("true");
                this.emulateEnter = prop.getProperty("emulateEnter").equals("true");
                this.autoStart = prop.getProperty("autoStart").equals("true");
                this.showStatePicture = prop.getProperty("showStatePicture").equals("true");
                this.bOtherPath = prop.getProperty("otherPath");
                this.bIExplorePath = prop.getProperty("iexplore");
                this.bFirefoxPath = prop.getProperty("firefox");
                this.bSafariPath = prop.getProperty("safari");
                this.bOperaPath = prop.getProperty("opera");
                this.bChromePath = prop.getProperty("chrome");
                this.topLevelDomain = prop.getProperty("TopLevelDomain", this.getDefaultTopLevelDomain());
                this.NewTabArgIE = prop.getProperty("NewTabArgumentInternetExplorer", "-newtab");
                this.NewTabArgFireFox = prop.getProperty("NewTabArgumentFirefox", "");
                this.NewTabArgOpera = prop.getProperty("NewTabArgumentOpera", "-newtab");
                this.NewTabArgChrome = prop.getProperty("NewTabArgumentChrome", "-new-tab");
                this.NewTabArgSafari = prop.getProperty("NewTabArgumentSafari", "-new-tab");
                this.NewTabArgOthers = prop.getProperty("NewTabArgumentOthers", "-new-tab");
                this.DuplicateRestarterTimeAfterTries = Integer.parseInt(prop.getProperty("DuplicateRestarterTimeAfterTries", "5"));
                this.MaxRestartTimeInSeconds = Integer.parseInt(prop.getProperty("MaxRestartTimeInSeconds", "3600"));
                this.RestartInterval = Integer.parseInt(prop.getProperty("RestartInterval", "60"));
                switch (this.OperatingSystem()) {
                    case WINDOWS: {
                        this.closeBrowserCommand = "pskill %s";
                        break;
                    }
                    case LINUX: {
                        this.closeBrowserCommand = "killall -9 -r ^%s.*";
                        break;
                    }
                    case MAC: {
                        this.closeBrowserCommand = "killall -9 %s";
                    }
                }
                this.closeBrowserCommand = prop.getProperty("CloseBrowserCommand", this.closeBrowserCommand);
                this.TopLevelDomains = prop.getProperty("TopLevelDomains", "de;com;ru;").split(";");
                try {
                    this.TimeToEmulateEnter = Integer.parseInt(prop.getProperty("TimeToEmulateEnter"));
                }
                catch (Exception e) {
                    this.TimeToEmulateEnter = 15;
                }
                boolean[] searchFor = new boolean[]{true, true, true, true, true};
                if (this.bIExplorePath == null || !new File(this.bIExplorePath).exists()) {
                    this.bIExplorePath = "n/A";
                    searchFor[0] = false;
                }
                if (this.bFirefoxPath == null || !new File(this.bFirefoxPath).exists()) {
                    this.bFirefoxPath = "n/A";
                    searchFor[1] = false;
                }
                if (this.bSafariPath == null || !new File(this.bSafariPath).exists()) {
                    this.bSafariPath = "n/A";
                    searchFor[4] = false;
                }
                if (this.bOperaPath == null || !new File(this.bOperaPath).exists()) {
                    this.bOperaPath = "n/A";
                    searchFor[2] = false;
                }
                if (this.bChromePath == null || !new File(this.bChromePath).exists()) {
                    this.bChromePath = "n/A";
                    searchFor[3] = false;
                }
                if (this.bOtherPath == null) {
                    this.bOtherPath = "n/A";
                }
                this.searchForBrowsers(searchFor);
                logger.info("loading settings successful");
            }
            catch (Exception e) {
                System.out.println("Fehler (" + e.getMessage() + ")");
                String[] text = new String[]{e.getMessage()};
                new InfoPopUp(null, "ERROR - Load Settings", text, 10000);
                logger.warning("loading settings failed: " + e.getMessage());
            }
            this.showLogInForm = false;
        } else {
            this.showLogInForm = true;
            this.showPopUp = true;
            this.restartBrowser = true;
            this.startWithLink = true;
            logger.warning("settings file not found. set all to default.");
        }
    }

    public void LoadLanguageFile() {
        Properties prop;
        File languageSettingsFile = new File(String.valueOf(SettingsPath) + "lang.ini");
        if (SettingsPath != null && languageSettingsFile.exists()) {
            prop = new Properties();
            try {
                FileInputStream fis = new FileInputStream(languageSettingsFile.getAbsolutePath());
                prop.load(fis);
                fis.close();
                logger.info("load language file succeed");
            }
            catch (FileNotFoundException e) {
                logger.warning("load language file failed: " + e.getMessage());
            }
            catch (IOException e) {
                logger.warning("load language file failed: " + e.getMessage());
            }
            this.language = prop.getProperty("language");
        } else {
            this.language = System.getProperty("user.language");
            logger.info("system language detected: " + this.language);
            if (!new File(String.valueOf(ProgramPath) + "lang/" + this.language + ".lang").exists()) {
                logger.warning("unsupported language selected: set language to english");
                this.language = "en";
            }
            if (SettingsPath != null) {
                prop = new Properties();
                prop.setProperty("language", this.language);
                try {
                    FileOutputStream fos = new FileOutputStream(String.valueOf(SettingsPath) + "lang.ini");
                    prop.store(fos, "Restarter Language Settings");
                    fos.close();
                    logger.info("saving language settings successful");
                }
                catch (Exception e) {
                    this.language = "en";
                    logger.warning("saving language settings failed. set language to english");
                }
            }
        }
        OptionsForm.setSaveState(24);
        this.Language = new Properties();
        try {
            File languageFile = new File(String.valueOf(ProgramPath) + "lang/" + this.language + ".lang");
            FileInputStream fis = new FileInputStream(languageFile.getAbsolutePath());
            OptionsForm.setSaveState(25);
            this.Language = PropertiesLoader.loadProperties(fis, "unicode");
            fis.close();
            logger.info("load language successful");
        }
        catch (Exception e) {
            logger.warning("loading language failed: " + e.getMessage());
            JOptionPane.showMessageDialog(null, "Fatal error on loading language file: \n\n" + e.getMessage());
        }
    }

    private boolean lookForJavaType(InputStream error) throws IOException {
        String s = this.getJavaVersion(error);
        String[] s1 = s.split("\n");
        this.useSunJava = s1.length >= 2 && s1[1].startsWith("Java(TM)");
        return this.useSunJava;
    }

    public OS OperatingSystem() {
        if (this.currentOS == null) {
            String os = System.getProperties().getProperty("os.name");
            SelectOSForm form = new SelectOSForm(null, os);
            this.currentOS = form.os;
            System.out.println((Object)this.currentOS);
            if (this.currentOS == OS.UNKNOWN) {
                logger.severe("operating system unsupported [" + os + "]");
                System.exit(0);
            }
        }
        return this.currentOS;
    }

    public boolean SaveData() {
        Properties prop;
        block10: {
            prop = new Properties();
            prop.setProperty("user", this.user);
            prop.setProperty("password", this.password);
            prop.setProperty("alwaysOnTop", this.alwaysOnTop ? "true" : "false");
            prop.setProperty("hideMenuForm", this.hideMenuForm ? "true" : "false");
            prop.setProperty("menuFormLeft", String.valueOf(this.menuFormLeft));
            prop.setProperty("menuFormTop", String.valueOf(this.menuFormTop));
            prop.setProperty("Browser", this.getBrowserFile());
            prop.setProperty("showPopUp", this.showPopUp ? "true" : "false");
            prop.setProperty("restartBrowser", this.restartBrowser ? "true" : "false");
            prop.setProperty("startWithLink", this.startWithLink ? "true" : "false");
            prop.setProperty("emulateEnter", this.emulateEnter ? "true" : "false");
            prop.setProperty("autoStart", this.autoStart ? "true" : "false");
            prop.setProperty("showStatePicture", this.showStatePicture ? "true" : "false");
            prop.setProperty("otherPath", this.bOtherPath);
            prop.setProperty("TimeToEmulateEnter", String.valueOf(this.TimeToEmulateEnter));
            if (!this.bIExplorePath.equals("n/A")) {
                prop.setProperty("iexplore", this.bIExplorePath);
            }
            if (!this.bFirefoxPath.equals("n/A")) {
                prop.setProperty("firefox", this.bFirefoxPath);
            }
            if (!this.bSafariPath.equals("n/A")) {
                prop.setProperty("safari", this.bSafariPath);
            }
            if (!this.bOperaPath.equals("n/A")) {
                prop.setProperty("opera", this.bOperaPath);
            }
            if (!this.bChromePath.equals("n/A")) {
                prop.setProperty("chrome", this.bChromePath);
            }
            prop.setProperty("TopLevelDomain", this.getTopLevelDomain());
            prop.setProperty("NewTabArgumentInternetExplorer", this.NewTabArgIE);
            prop.setProperty("NewTabArgumentFirefox", this.NewTabArgFireFox);
            prop.setProperty("NewTabArgumentOpera", this.NewTabArgOpera);
            prop.setProperty("NewTabArgumentChrome", this.NewTabArgChrome);
            prop.setProperty("NewTabArgumentSafari", this.NewTabArgSafari);
            prop.setProperty("NewTabArgumentOthers", this.NewTabArgOthers);
            prop.setProperty("DuplicateRestarterTimeAfterTries", String.valueOf(this.DuplicateRestarterTimeAfterTries));
            prop.setProperty("MaxRestartTimeInSeconds", String.valueOf(this.MaxRestartTimeInSeconds));
            prop.setProperty("RestartInterval", String.valueOf(this.RestartInterval));
            if (this.closeBrowserCommand != null) {
                prop.setProperty("CloseBrowserCommand", this.closeBrowserCommand);
            }
            String topLevelDomains = "";
            String[] stringArray = this.TopLevelDomains;
            int n = this.TopLevelDomains.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                topLevelDomains = String.valueOf(topLevelDomains) + s + ";";
                ++n2;
            }
            prop.setProperty("TopLevelDomains", topLevelDomains);
            try {
                File f = new File(SettingsPath);
                if (this.OperatingSystem() != OS.WINDOWS || f.exists() || f.mkdir()) break block10;
                System.out.println("Fehler (Konnte Pfad nicht erstellen)");
                JOptionPane pane = new JOptionPane();
                pane.setMessage("Fehler beim Speichern!");
                pane.setVisible(true);
                return false;
            }
            catch (Exception e) {
                logger.warning("saving settings failed: " + e.getMessage());
                JOptionPane pane = new JOptionPane();
                pane.setMessage("Fehler beim Speichern!\nError: " + e.getMessage() + "\nLocation: " + e.getLocalizedMessage());
                pane.setVisible(true);
                return false;
            }
        }
        FileOutputStream fos = new FileOutputStream(String.valueOf(SettingsPath) + "data.ini");
        prop.store(fos, "Restarter Settings");
        fos.close();
        logger.info("savig settings successful");
        return true;
    }

    public void searchForBrowsers(boolean[] searchFor) {
        if (this.OperatingSystem() == OS.WINDOWS) {
            this.getBrowsers = new GetBrowsers(searchFor);
            this.getBrowsers.start();
        }
    }

    public void SetAccount(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public void setBrowser(String browser) {
        this.browserFile = browser;
    }

    public void SetOperatingSystem(OS os) {
        this.currentOS = os;
    }

    public void setTopLevelDomain(String topLevelDomain) {
        this.topLevelDomain = topLevelDomain;
    }

    public void ShowMenuForm(boolean show) {
        boolean bl = this.hideMenuForm = !show;
        if (!this.hideMenuForm) {
            Program.menuForm.Show();
        }
    }

    public String getCloseBrowserCommand() {
        if (this.closeBrowserCommand == null) {
            switch (this.OperatingSystem()) {
                case WINDOWS: {
                    this.closeBrowserCommand = "pskill %s";
                    break;
                }
                case LINUX: {
                    this.closeBrowserCommand = "killall -9 -r ^%s.*";
                    break;
                }
                case MAC: {
                    this.closeBrowserCommand = "killall -9 %s";
                }
            }
        }
        return this.closeBrowserCommand;
    }

    public String getStartBrowserCommand() {
        return this.startBrowserCommand;
    }

    public static enum StartOptions {
        START_WITHOUT_LINK,
        RESTARTED;

    }
}

