/*
 * Decompiled with CFR 0.152.
 */
package restarter;

import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Logger;
import restarter.KeyValue;
import restarter.PopUp;
import restarter.PopUpTimerTask;
import restarter.Program;
import restarter.ServerWork;
import restarter.Settings;
import restarter.enums.RunningStates;

public class Task
extends TimerTask {
    private static final Logger logger = Logger.getLogger(Task.class.getName());
    private static Vector<KeyValue> lastResponce;
    public static Timer timer;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    private void restartBrowser() {
        String buttonText;
        String text;
        logger.info("restart browser");
        Program.StopTimer();
        Program.menuForm.SetProgramWorkState(RunningStates.RESTARTING);
        Settings.Default().BrowserStartOption = Settings.StartOptions.START_WITHOUT_LINK;
        timer = new Timer();
        if (Settings.Default().restartBrowser) {
            text = String.valueOf(Settings.getText("RESTART_RESTART")) + "\n" + Settings.getText("RESTART_BROWSERCLOSEOPEN");
            buttonText = Settings.getText("TAG_SKIP");
        } else {
            text = String.valueOf(Settings.getText("RESTART_SURFBARSTOPPED")) + "\n" + Settings.getText("RESTART_DISABLED");
            buttonText = Settings.getText("TAG_OK");
        }
        timer.schedule((TimerTask)new PopUpTimerTask(new PopUp(null, text, buttonText, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public void doOnTimerDelay() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                String s = event.getActionCommand();
                if (s.equals("button1")) {
                    timer.cancel();
                    Program.StartTimer(Settings.Default().timerDelay);
                    this.CloseWindow();
                }
            }
        }), 1000L, 1000L);
    }

    private static long DateToLong(String date) {
        long res = 0L;
        res += (long)(Integer.parseInt(date.substring(12, 14)) * 3600);
        res += (long)(Integer.parseInt(date.substring(15, 17)) * 60);
        return res += (long)Integer.parseInt(date.substring(18, 20));
    }

    public static boolean check(Vector<KeyValue> responce) {
        long actual;
        long last;
        if (Task.getLastResponce() == null) {
            Task.setLastResponce(responce);
            return true;
        }
        String actualServerTime = KeyValue.getValue(responce, "Now");
        if (actualServerTime != null) {
            last = Task.DateToLong(KeyValue.getValue(responce, "Last_Time"));
            actual = Task.DateToLong(actualServerTime);
        } else {
            last = Task.DateToLong(KeyValue.getValue(Task.getLastResponce(), "Last_Time"));
            actual = Task.DateToLong(KeyValue.getValue(responce, "Last_Time"));
        }
        if (last > actual) {
            actual += 86400L;
        }
        Task.setLastResponce(responce);
        return actual - last <= 60L;
    }

    @Override
    public void run() {
        if (timer != null) {
            timer.cancel();
        }
        if (--Program.nextCheckCounter <= 0) {
            logger.info("surfbar isn't running yet.");
            Program.menuForm.counterLabel.setText(Settings.getText("RESTART_CHECK"));
            Program.menuForm.SetProgramWorkState(RunningStates.CHECKING);
            try {
                if (!Task.check(ServerWork.GetResponse()) || KeyValue.getValue(Task.getLastResponce(), "Timeout_reached").equals("true")) {
                    if (Settings.Default().restartBrowser && Settings.Default().BrowserStartOption == Settings.StartOptions.RESTARTED) {
                        ++Settings.Default().RestartFailures;
                        Settings.Default().timerDelay = Settings.Default().RestartFailures <= Settings.Default().DuplicateRestarterTimeAfterTries ? Settings.Default().RestartInterval : (Settings.Default().timerDelay *= 2);
                        if (Settings.Default().timerDelay > Settings.Default().MaxRestartTimeInSeconds) {
                            Settings.Default().timerDelay = Settings.Default().MaxRestartTimeInSeconds;
                        }
                    }
                    if (Settings.Default().BrowserStartOption == Settings.StartOptions.RESTARTED) {
                        Program.menuForm.SetProgramWorkState(RunningStates.RESTARTING);
                        Settings.Default().BrowserStartOption = Settings.StartOptions.START_WITHOUT_LINK;
                        new PopUp(null, String.valueOf(Settings.getText("RESTART_RESTART")) + "\n" + Settings.getText("RESTART_CALLLINK"), Settings.getText("TAG_SKIP"), 5000){
                            private static final long serialVersionUID = 1L;
                            private boolean doRestart;
                            {
                                this.doRestart = true;
                            }

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                String s = event.getActionCommand();
                                if (s.equals("button1")) {
                                    timer.cancel();
                                    this.doRestart = false;
                                    this.CloseWindow();
                                }
                            }

                            @Override
                            public void doOnTimerDelay() {
                                if (this.doRestart) {
                                    PopUpTimerTask.StartBrowser(true);
                                } else {
                                    logger.info("restarting is diabled");
                                }
                                this.CloseWindow();
                            }
                        };
                    } else {
                        this.restartBrowser();
                    }
                } else if (Settings.Default().BrowserStartOption == Settings.StartOptions.RESTARTED) {
                    Settings.Default().BrowserStartOption = Settings.StartOptions.START_WITHOUT_LINK;
                    Program.menuForm.SetProgramWorkState(RunningStates.RUNNING);
                    Settings.Default().RestartFailures = -1;
                    Settings.Default().timerDelay = Settings.Default().RestartInterval;
                } else {
                    Program.menuForm.SetProgramWorkState(RunningStates.RUNNING);
                    Settings.Default().RestartFailures = -1;
                    Settings.Default().timerDelay = Settings.Default().RestartInterval;
                }
            }
            catch (Exception e) {
                Program.menuForm.SetProgramWorkState(RunningStates.NOCONNECTION);
                logger.warning("error on restarting: " + e.getMessage());
            }
            Program.nextCheckCounter = Settings.Default().timerDelay;
        } else {
            String counterLabelText = Settings.Default().RestartFailures <= 0 ? Settings.getText("RESTART_CHECKIN").replace("$nextCheckCounter", String.valueOf(Program.nextCheckCounter)) : Settings.getText("SURFBAR_START_TRIES").replace("{0}", String.valueOf(Settings.Default().RestartFailures)).replace("{1}", String.valueOf(Program.nextCheckCounter));
            Program.menuForm.counterLabel.setText(counterLabelText);
        }
    }

    public static void setLastResponce(Vector<KeyValue> lastResponce) {
        Task.lastResponce = lastResponce;
    }

    public static Vector<KeyValue> getLastResponce() {
        return lastResponce;
    }
}

