/*
 * Decompiled with CFR 0.152.
 */
package restarter;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import restarter.Program;
import restarter.Settings;
import restarter.forms.TrayMenu;

public class Tray {
    private static final Logger logger = Logger.getLogger(Tray.class.getName());
    private TrayIcon trayIcon;
    public TrayMenu trayMenu;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    public Tray() throws Exception {
        if (!SystemTray.isSupported()) {
            logger.warning("tray isn't supported");
            throw new Exception("Tray not supported!");
        }
        this.trayMenu = new TrayMenu();
        SystemTray tray = SystemTray.getSystemTray();
        Image image = Program.programImage;
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
        this.trayIcon = new TrayIcon(image, Settings.Default().ProductName, this.trayMenu);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Program.menuForm.Show();
            }
        };
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addActionListener(actionListener);
        this.trayIcon.addMouseListener(mouseListener);
        try {
            tray.add(this.trayIcon);
        }
        catch (AWTException e) {
            System.err.println("TrayIcon could not be added.");
        }
    }

    public void setName(String name) {
        this.trayIcon.setToolTip(name);
    }
}

