/*
 * Decompiled with CFR 0.152.
 */
package restarter;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import restarter.Program;

public class ViewComponent
extends JComponent {
    private static final long serialVersionUID = 4720L;
    private Image image;
    private List<Image> images;
    private int x = 0;
    private ArrayList<String> texts = null;
    private JTextArea textArea = null;
    private int y = 0;
    private ImageLayout imageLayout = ImageLayout.Fill;

    public ImageLayout getImageLayout() {
        return this.imageLayout;
    }

    public void setImageLayout(ImageLayout imageLayout) {
        this.imageLayout = imageLayout;
    }

    public ArrayList<String> getTexts() {
        return this.texts;
    }

    public ViewComponent(String file, String text, ImageLayout layout) {
        this(file, text);
        this.imageLayout = layout;
        this.repaint();
    }

    public ViewComponent(String file, String text) {
        this.images = new ArrayList<Image>();
        if (text != null) {
            this.texts = new ArrayList();
            this.textArea = new JTextArea();
            this.textArea.setEditable(false);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setFont(new Font("Arial", 1, 14));
            this.textArea.setOpaque(false);
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            layout.setConstraints(this.textArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.textArea);
        }
        this.addImage(file, text);
        this.image = this.images.get(0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
        if (this.image != null) {
            switch (this.imageLayout) {
                case Fill: {
                    g.drawImage(this.image, this.x, this.y, this.getWidth() - this.x, this.getHeight() - this.y, this);
                    break;
                }
                case Squared: {
                    g.drawImage(this.image, this.getWidth() / 2 - this.image.getWidth(this) / 2, 0, this.image.getWidth(this), this.image.getHeight(this), this);
                    break;
                }
                case None: {
                    g.drawImage(this.image, this.x, this.y, this);
                    break;
                }
            }
        }
    }

    public void addImage(String file, String text) {
        this.images.add(Toolkit.getDefaultToolkit().getImage(Program.class.getResource(file)));
        if (text != null) {
            this.texts.add(text);
        }
    }

    public void setImage(int index) {
        this.image = this.images.get(index);
        if (this.textArea != null) {
            if (this.texts.get(index).length() > 35) {
                this.textArea.setFont(new Font("Arial", 1, 12));
            } else {
                this.textArea.setFont(new Font("Arial", 1, 14));
            }
            this.textArea.setText(this.texts.get(index));
        }
        this.repaint();
    }

    public int getImageIndex() {
        return this.images.indexOf(this.image);
    }

    public Image getActualImage() {
        return this.image;
    }

    public void CenterImage(int width, int height) {
        this.x = this.getWidth() / 2;
        this.y = this.getHeight() / 2;
        this.repaint();
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public static enum ImageLayout {
        Squared,
        Fill,
        None;

    }
}

