/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import restarter.Program;
import restarter.Settings;
import restarter.enums.OS;

public class BrowserPanel
extends JPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(BrowserPanel.class.getName());
    private static final long serialVersionUID = 1L;
    private JLabel bTopLabel;
    private JRadioButton bIExplorer;
    private JRadioButton bFirefox;
    private JRadioButton bChrome;
    private JRadioButton bSafari;
    private JRadioButton bOpera;
    private JRadioButton bOther;
    private TextField bOtherTextField;
    private JButton bBrowseOther;
    private JButton bFindBrowserButton;
    private JLabel bFindBrowserLabel;
    private GridBagLayout browserPanelLayout;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    public BrowserPanel() {
        logger.log(Level.INFO, "create browser panel");
        if (Settings.Default().getBrowsers != null && Settings.Default().getBrowsers.isAlive()) {
            Settings.Default().getBrowsers.SetSettingsWindow(this);
        }
        this.Initialize();
    }

    private void MarkBrowserRadioButton(String s) {
        if ((s = s.toLowerCase()).equals("iexplore")) {
            this.getBIExplorer().setSelected(true);
            this.getBFirefox().setSelected(false);
            this.getBChrome().setSelected(false);
            this.getBSafari().setSelected(false);
            this.getBOpera().setSelected(false);
            this.getBOther().setSelected(false);
            this.getBOtherTextField().setEditable(false);
            this.getBBrowseOther().setEnabled(false);
        } else if (s.equals("firefox")) {
            this.getBIExplorer().setSelected(false);
            this.getBFirefox().setSelected(true);
            this.getBChrome().setSelected(false);
            this.getBSafari().setSelected(false);
            this.getBOpera().setSelected(false);
            this.getBOther().setSelected(false);
            this.getBOtherTextField().setEditable(false);
            this.getBBrowseOther().setEnabled(false);
        } else if (s.equals("chrome")) {
            this.getBIExplorer().setSelected(false);
            this.getBFirefox().setSelected(false);
            this.getBChrome().setSelected(true);
            this.getBSafari().setSelected(false);
            this.getBOpera().setSelected(false);
            this.getBOther().setSelected(false);
            this.getBOtherTextField().setEditable(false);
            this.getBBrowseOther().setEnabled(false);
        } else if (s.equals("safari")) {
            this.getBIExplorer().setSelected(false);
            this.getBFirefox().setSelected(false);
            this.getBChrome().setSelected(false);
            this.getBSafari().setSelected(true);
            this.getBOpera().setSelected(false);
            this.getBOther().setSelected(false);
            this.getBOtherTextField().setEditable(false);
            this.getBBrowseOther().setEnabled(false);
        } else if (s.equals("opera")) {
            this.getBIExplorer().setSelected(false);
            this.getBFirefox().setSelected(false);
            this.getBChrome().setSelected(false);
            this.getBSafari().setSelected(false);
            this.getBOpera().setSelected(true);
            this.getBOther().setSelected(false);
            this.getBOtherTextField().setEditable(false);
            this.getBBrowseOther().setEnabled(false);
        } else {
            this.getBIExplorer().setSelected(false);
            this.getBFirefox().setSelected(false);
            this.getBChrome().setSelected(false);
            this.getBChrome().setSelected(false);
            this.getBOpera().setSelected(false);
            this.getBOther().setSelected(true);
            this.getBOtherTextField().setEditable(true);
            this.getBBrowseOther().setEnabled(true);
            this.getBOtherTextField().setText(s);
        }
    }

    private void Initialize() {
        GridBagConstraints cons = new GridBagConstraints();
        this.browserPanelLayout = new GridBagLayout();
        this.setLayout(this.browserPanelLayout);
        cons.fill = 2;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.insets = new Insets(2, 2, 2, 2);
        String labelText = Settings.getText("BROWSERPANEL_CHOOSEBROWSER");
        if (Settings.Default().getBrowsers != null && Settings.Default().getBrowsers.isAlive()) {
            labelText = String.valueOf(labelText) + " (" + Settings.getText("BROWSERPANEL_SEARCHING") + ")";
        }
        this.setBTopLabel(new JLabel(labelText));
        cons.gridwidth = 4;
        this.browserPanelLayout.setConstraints(this.getBTopLabel(), cons);
        this.add(this.getBTopLabel());
        this.setBIExplorer(new JRadioButton("Internet Explorer"));
        this.getBIExplorer().addActionListener(this);
        this.getBIExplorer().setActionCommand("iexplore");
        this.getBIExplorer().setSelected(Settings.Default().getBrowserFile().toLowerCase().equals(Settings.Default().bIExplorePath.toLowerCase()));
        this.getBIExplorer().setVisible(Settings.Default().OperatingSystem() == OS.WINDOWS);
        if (Settings.Default().OperatingSystem() != OS.WINDOWS || !Settings.Default().bIExplorePath.equals("n/A")) {
            this.getBIExplorer().setEnabled(true);
            this.getBIExplorer().setToolTipText(Settings.Default().bIExplorePath);
        } else {
            this.getBIExplorer().setEnabled(false);
        }
        cons.gridy = 1;
        cons.gridwidth = 1;
        this.browserPanelLayout.setConstraints(this.getBIExplorer(), cons);
        this.add(this.getBIExplorer());
        this.setBFirefox(new JRadioButton("Firefox"));
        this.getBFirefox().addActionListener(this);
        this.getBFirefox().setActionCommand("firefox");
        if (Settings.Default().OperatingSystem() == OS.WINDOWS) {
            this.getBFirefox().setSelected(Settings.Default().getBrowserFile().toLowerCase().equals(Settings.Default().bFirefoxPath.toLowerCase()));
        } else {
            this.getBFirefox().setSelected(Settings.Default().getBrowserFile().toLowerCase().equals("firefox"));
        }
        if (Settings.Default().OperatingSystem() != OS.WINDOWS || !Settings.Default().bFirefoxPath.equals("n/A")) {
            this.getBFirefox().setEnabled(true);
            this.getBFirefox().setToolTipText(Settings.Default().bFirefoxPath);
        } else {
            this.getBFirefox().setEnabled(false);
        }
        cons.gridy = 2;
        this.browserPanelLayout.setConstraints(this.getBFirefox(), cons);
        this.add(this.getBFirefox());
        this.setBChrome(new JRadioButton("Google Chrome"));
        this.getBChrome().addActionListener(this);
        this.getBChrome().setActionCommand("chrome");
        if (Settings.Default().OperatingSystem() == OS.WINDOWS) {
            this.getBChrome().setSelected(Settings.Default().getBrowserFile().toLowerCase().equals(Settings.Default().bChromePath.toLowerCase()));
        } else {
            this.getBChrome().setSelected(Settings.Default().getBrowserFile().toLowerCase().equals("chrome"));
        }
        if (Settings.Default().OperatingSystem() != OS.WINDOWS || !Settings.Default().bChromePath.equals("n/A")) {
            this.getBChrome().setEnabled(true);
            this.getBChrome().setToolTipText(Settings.Default().bChromePath);
        } else {
            this.getBChrome().setEnabled(false);
        }
        cons.gridy = 3;
        this.browserPanelLayout.setConstraints(this.getBChrome(), cons);
        this.add(this.getBChrome());
        this.setBSafari(new JRadioButton("Apple Safari"));
        this.getBSafari().addActionListener(this);
        this.getBSafari().setActionCommand("safari");
        if (Settings.Default().OperatingSystem() == OS.WINDOWS) {
            this.getBSafari().setSelected(Settings.Default().getBrowserFile().toLowerCase().equals(Settings.Default().bSafariPath.toLowerCase()));
        } else {
            this.getBSafari().setSelected(Settings.Default().getBrowserFile().toLowerCase().equals("safari"));
        }
        if (Settings.Default().OperatingSystem() != OS.WINDOWS || !Settings.Default().bChromePath.equals("n/A")) {
            this.getBSafari().setEnabled(true);
            this.getBSafari().setToolTipText(Settings.Default().bSafariPath);
        } else {
            this.getBSafari().setEnabled(false);
        }
        cons.gridy = 4;
        this.browserPanelLayout.setConstraints(this.getBSafari(), cons);
        this.add(this.getBSafari());
        this.setBOpera(new JRadioButton("Opera"));
        this.getBOpera().addActionListener(this);
        this.getBOpera().setActionCommand("opera");
        if (Settings.Default().OperatingSystem() == OS.WINDOWS) {
            this.getBOpera().setSelected(Settings.Default().getBrowserFile().toLowerCase().equals(Settings.Default().bOperaPath.toLowerCase()));
        } else {
            this.getBOpera().setSelected(Settings.Default().getBrowserFile().toLowerCase().equals("opera"));
        }
        if (Settings.Default().OperatingSystem() != OS.WINDOWS || !Settings.Default().bOperaPath.equals("n/A")) {
            this.getBOpera().setEnabled(true);
            this.getBOpera().setToolTipText(Settings.Default().bOperaPath);
        } else {
            this.getBOpera().setEnabled(false);
        }
        cons.gridy = 5;
        this.browserPanelLayout.setConstraints(this.getBOpera(), cons);
        this.add(this.getBOpera());
        this.setBOther(new JRadioButton(String.valueOf(Settings.getText("TAG_OTHER")) + ":"));
        this.getBOther().addActionListener(this);
        this.getBOther().setActionCommand("other");
        cons.gridy = 6;
        this.browserPanelLayout.setConstraints(this.getBOther(), cons);
        this.add(this.getBOther());
        this.setBOtherTextField(new TextField());
        this.getBOtherTextField().setEditable(this.getBOther().isSelected());
        this.getBOtherTextField().setText(Settings.Default().bOtherPath.equals("n/A") ? "" : Settings.Default().bOtherPath);
        cons.weightx = 1.0;
        cons.gridwidth = 2 + (Settings.Default().OperatingSystem() == OS.WINDOWS ? 0 : 1);
        cons.gridx = 1;
        cons.fill = 1;
        this.browserPanelLayout.setConstraints(this.getBOtherTextField(), cons);
        this.add(this.getBOtherTextField());
        this.setBBrowseOther(new JButton());
        this.getBBrowseOther().setText(String.valueOf(Settings.getText("TAG_CHOOSE")) + "...");
        this.getBBrowseOther().setVisible(Settings.Default().OperatingSystem() == OS.WINDOWS);
        this.getBBrowseOther().setEnabled(this.getBOther().isSelected());
        this.getBBrowseOther().addActionListener(this);
        this.getBBrowseOther().setActionCommand("BrowseOther");
        cons.gridx = 3;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        this.browserPanelLayout.setConstraints(this.getBBrowseOther(), cons);
        this.add(this.getBBrowseOther());
        if (!Settings.Default().bOtherPath.equals("n/A")) {
            this.MarkBrowserRadioButton(Settings.Default().getBrowserFile());
        }
        this.bFindBrowserButton = new JButton("Automatisch bestimmen");
        this.bFindBrowserButton.addActionListener(this);
        this.bFindBrowserButton.setActionCommand("find");
        this.bFindBrowserButton.setVisible(false);
        cons.gridx = 2;
        cons.gridy = 7;
        cons.weightx = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(2, 6, 0, 6);
        cons.fill = 2;
        this.browserPanelLayout.setConstraints(this.bFindBrowserButton, cons);
        this.add(this.bFindBrowserButton);
        this.bFindBrowserLabel = new JLabel(Settings.getText("BROWSERPANEL_MSGBROWSERMUSTBEOPENED"));
        this.bFindBrowserLabel.setFont(new Font("Arial", 2, 12));
        this.bFindBrowserLabel.setVisible(false);
        cons.gridx = 2;
        cons.gridy = 8;
        cons.weightx = 0.0;
        cons.gridwidth = 1;
        cons.fill = 10;
        cons.insets = new Insets(0, 6, 2, 6);
        this.browserPanelLayout.setConstraints(this.bFindBrowserLabel, cons);
        this.add(this.bFindBrowserLabel);
        this.browserPanelLayout.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.browserPanelLayout.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0};
    }

    private void setBIExplorer(JRadioButton radioButton) {
        this.bIExplorer = radioButton;
    }

    public JRadioButton getBIExplorer() {
        return this.bIExplorer;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String s = arg0.getActionCommand();
        if (s.equals("BrowseOther")) {
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.getName().toLowerCase().endsWith(".exe");
                }

                @Override
                public String getDescription() {
                    return Settings.getText("TAG_PROGRAMS");
                }
            });
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showOpenDialog(this) == 0) {
                this.getBOtherTextField().setText(chooser.getSelectedFile().getPath());
                logger.log(Level.INFO, "browser choosen by user: " + chooser.getSelectedFile().getPath());
            }
        } else {
            this.MarkBrowserRadioButton(s);
        }
    }

    public void setBFirefox(JRadioButton bFirefox) {
        this.bFirefox = bFirefox;
    }

    public JRadioButton getBFirefox() {
        return this.bFirefox;
    }

    public void setBSafari(JRadioButton bSafari) {
        this.bSafari = bSafari;
    }

    public void setBOpera(JRadioButton bOpera) {
        this.bOpera = bOpera;
    }

    public JRadioButton getBOpera() {
        return this.bOpera;
    }

    public void setBChrome(JRadioButton bChrome) {
        this.bChrome = bChrome;
    }

    public JRadioButton getBChrome() {
        return this.bChrome;
    }

    public void setBTopLabel(JLabel bTopLabel) {
        this.bTopLabel = bTopLabel;
    }

    public JLabel getBTopLabel() {
        return this.bTopLabel;
    }

    public void setBOtherTextField(TextField bOtherTextField) {
        this.bOtherTextField = bOtherTextField;
    }

    public TextField getBOtherTextField() {
        return this.bOtherTextField;
    }

    public void setBOther(JRadioButton bOther) {
        this.bOther = bOther;
    }

    public JRadioButton getBOther() {
        return this.bOther;
    }

    public void setBBrowseOther(JButton bBrowseOther) {
        this.bBrowseOther = bBrowseOther;
    }

    public JButton getBBrowseOther() {
        return this.bBrowseOther;
    }

    public JRadioButton getBSafari() {
        return this.bSafari;
    }
}

