/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import restarter.Settings;
import restarter.forms.swing.WindowTools;

public class ChooseDomainPanel
extends Panel
implements ActionListener {
    private static final long serialVersionUID = 1085694506425112878L;
    private ButtonGroup selectedDomainButtonGroup;
    private JLabel surfbarLinkLabel;

    public ChooseDomainPanel() {
        this.initialize();
    }

    private void initialize() {
        WindowTools.defaultForegroundColor = Color.black;
        GridBagConstraints cons = new GridBagConstraints();
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        WindowTools.createLabel(layout, cons, Settings.getText("SELECT_USING_DOMAIN"), 12, 2, 0, 0, 1, 1, 0.0f, 0.0f, new Insets(0, 0, 0, 0), this);
        int row = 1;
        this.setSelectionButtonGroup(new ButtonGroup());
        String[] stringArray = Settings.Default().TopLevelDomains;
        int n = Settings.Default().TopLevelDomains.length;
        int n2 = 0;
        while (n2 < n) {
            String domain = stringArray[n2];
            JRadioButton btn = WindowTools.createComponent(new JRadioButton("eBesucher." + domain + " (" + Settings.getText("DOMAIN_LANGUAGE_" + domain.toUpperCase()) + ")"), layout, cons, 12, 2, 0, row++, 1, 1, 1.0f, 0.0f, new Insets(0, 0, 0, 0), this);
            this.getSelectedDomainButtonGroup().add(btn);
            if (domain.equals(Settings.Default().getTopLevelDomain())) {
                btn.setSelected(true);
            }
            btn.addActionListener(this);
            btn.setActionCommand(domain);
            ++n2;
        }
        WindowTools.createLabel(layout, cons, Settings.getText("CURRENT_SURFBAR_LINK"), 14, 2, 0, row++, 1, 1, 0.0f, 1.0f, new Insets(0, 0, 0, 0), this);
        this.surfbarLinkLabel = WindowTools.createLabel(layout, cons, Settings.Default().getSurfbarLink(), 12, 2, 0, row++, 1, 1, 0.0f, 0.0f, new Insets(0, 0, 0, 0), this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("auto_select")) {
            String domain = Settings.Default().getDefaultTopLevelDomain();
            Enumeration<AbstractButton> buttons = this.getSelectedDomainButtonGroup().getElements();
            while (buttons.hasMoreElements()) {
                AbstractButton btn = buttons.nextElement();
                if (!btn.getActionCommand().equals(domain)) continue;
                btn.setSelected(true);
                break;
            }
        } else {
            String link = "http://www." + Settings.Default().Domain + "." + e.getActionCommand() + "/" + Settings.Default().SurfbarLink;
            this.surfbarLinkLabel.setText(link);
        }
    }

    private void setSelectionButtonGroup(ButtonGroup selectionButtonGroup) {
        this.selectedDomainButtonGroup = selectionButtonGroup;
    }

    public ButtonGroup getSelectedDomainButtonGroup() {
        return this.selectedDomainButtonGroup;
    }
}

