/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import restarter.Program;
import restarter.Settings;
import restarter.forms.ChooseLanguagePanel;

public class ChooseLanguageForm
extends JDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ChooseLanguageForm.class.getName());
    private static final long serialVersionUID = 3904527357894478696L;
    private ChooseLanguagePanel langPanel;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    public ChooseLanguageForm(Frame owner) {
        super(owner, Settings.getText("LANGUAGE"), true);
        logger.log(Level.INFO, "create");
        GridBagConstraints cons = new GridBagConstraints();
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        cons.fill = 2;
        cons.anchor = 10;
        cons.gridwidth = 2;
        cons.weighty = 1.0;
        this.langPanel = new ChooseLanguagePanel();
        layout.setConstraints(this.langPanel, cons);
        this.add(this.langPanel);
        JButton okButton = new JButton(Settings.getText("TAG_OK"));
        okButton.setActionCommand("LANG_OK");
        okButton.addActionListener(this);
        cons.fill = 0;
        cons.anchor = 13;
        cons.gridy = 1;
        cons.gridwidth = 1;
        cons.weighty = 0.0;
        cons.weightx = 1.0;
        cons.insets = new Insets(4, 4, 4, 4);
        layout.setConstraints(okButton, cons);
        this.add(okButton);
        JButton exitButton = new JButton(Settings.getText("TAG_EXIT"));
        exitButton.setActionCommand("LANG_EXIT");
        exitButton.addActionListener(this);
        cons.gridx = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        layout.setConstraints(exitButton, cons);
        this.add(exitButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ChooseLanguageForm.this.ExitProgram();
                System.exit(0);
            }
        });
        this.setResizable(false);
        this.setBounds(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - 128, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - 90, 256, 180);
        this.setIconImage(Program.programImage);
        this.setVisible(true);
    }

    protected void ExitProgram() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String s = arg0.getActionCommand();
        if (s.equals("LANG_OK")) {
            logger.log(Level.INFO, "langueage selected");
            this.langPanel.Save();
            this.ExitProgram();
        } else if (s.equals("LANG_EXIT")) {
            logger.log(Level.INFO, "form closed by user");
            this.ExitProgram();
            System.exit(0);
        }
    }
}

