/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import restarter.Program;
import restarter.PropertiesLoader;
import restarter.Settings;
import restarter.forms.OptionsForm;

public class ChooseLanguagePanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(ChooseLanguagePanel.class.getName());
    private static final long serialVersionUID = -7731394015903603635L;
    private JComboBox languageComboBox;
    private HashMap<String, String> languages = new HashMap();

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    public ChooseLanguagePanel() {
        logger.log(Level.INFO, "create");
        this.Initialize();
    }

    private void Initialize() {
        GridBagConstraints cons = new GridBagConstraints();
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JLabel upperLabel1 = new JLabel(Settings.getText("LANGUAGE_CHOOSE"));
        cons.fill = 1;
        cons.anchor = 18;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 2;
        cons.gridheight = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.insets = new Insets(4, 4, 2, 4);
        layout.setConstraints(upperLabel1, cons);
        this.add(upperLabel1);
        this.languageComboBox = new JComboBox();
        this.getAvailableLanguages();
        cons.anchor = 11;
        cons.fill = 2;
        cons.gridy = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.insets = new Insets(8, 16, 4, 16);
        layout.setConstraints(this.languageComboBox, cons);
        this.add(this.languageComboBox);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setLocation(x, y);
        this.setVisible(true);
    }

    private String[] getAvailableLanguages() {
        ArrayList<String> al = new ArrayList<String>();
        File file = new File("lang");
        Properties languages = new Properties();
        try {
            FileInputStream fis = new FileInputStream(file.getAbsoluteFile() + "/lang.ini");
            languages = PropertiesLoader.loadProperties(fis, "unicode");
            fis.close();
            logger.info("read available languages");
        }
        catch (FileNotFoundException e) {
            logger.warning("lang/lang.ini not found");
        }
        catch (IOException e) {
            logger.warning("lang/lang.ini corrupted: " + e.getMessage());
        }
        int i = 0;
        String[] stringArray = file.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String elem = stringArray[n2];
            if (elem.endsWith(".lang")) {
                elem = elem.substring(0, elem.length() - 5);
                al.add(languages.getProperty(elem));
                if (elem == Settings.Default().language) {
                    this.languageComboBox.setSelectedIndex(i);
                }
                this.languages.put(languages.getProperty(elem), elem);
                this.languageComboBox.addItem(languages.getProperty(elem));
                if (Settings.Default().language.equals(elem)) {
                    this.languageComboBox.setSelectedIndex(i);
                }
                ++i;
            }
            ++n2;
        }
        String[] res = new String[al.size()];
        i = 0;
        while (i < al.size()) {
            res[i] = (String)al.get(i);
            ++i;
        }
        return res;
    }

    public void Save() {
        Properties prop = new Properties();
        prop.setProperty("language", this.languages.get(this.languageComboBox.getSelectedItem().toString()));
        String fullPath = String.valueOf(Settings.SettingsPath) + "lang.ini";
        try {
            FileOutputStream fos = new FileOutputStream(fullPath);
            prop.store(fos, "Restarter Language Settings");
            fos.close();
            logger.info("language saved");
        }
        catch (FileNotFoundException e) {
            logger.warning("language save file not found");
        }
        catch (IOException e) {
            logger.warning("error while saving current language: " + e.getMessage());
        }
        OptionsForm.setSaveState(22);
        Settings.Default().LoadLanguageFile();
    }
}

