/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import restarter.PopUpTimerTask;
import restarter.Program;
import restarter.Settings;
import restarter.ViewComponent;
import restarter.enums.OS;

public class CreditsForm
extends JDialog
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 4720L;
    JLabel[] labels;
    JButton closeButton;
    ViewComponent eBesucherLogo;
    ViewComponent zeraSothLogo;
    GridBagLayout layout;

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource().equals(this.labels[3])) {
            PopUpTimerTask.StartBrowser("http://www." + Settings.Default().Domain + "." + Settings.Default().getTopLevelDomain());
        } else if (e.getSource().equals(this.labels[5])) {
            PopUpTimerTask.StartBrowser("mailto:peter@ebesucher.de");
        } else if (e.getSource().equals(this.labels[7])) {
            PopUpTimerTask.StartBrowser("mailto:support@ebesucher.de");
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public CreditsForm(JFrame owner) throws HeadlessException {
        super(owner, Settings.getText("TAG_ABOUT"), true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                CreditsForm.this.ExitProgram();
            }
        });
        this.Initialize();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String s = arg0.getActionCommand();
        if (s.equals("close")) {
            this.ExitProgram();
        }
    }

    private void ExitProgram() {
        this.setVisible(false);
        this.dispose();
    }

    private void Initialize() {
        GridBagConstraints cons = new GridBagConstraints();
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.labels = new JLabel[8];
        cons.fill = 0;
        cons.anchor = 17;
        cons.weighty = 0.0;
        int i = 0;
        while (i < this.labels.length) {
            this.labels[i] = new JLabel();
            switch (i) {
                case 0: {
                    this.labels[i].setText(Settings.Default().ProductName);
                    this.labels[i].setFont(new Font("Arial", 1, 24));
                    cons.insets = new Insets(12, 12, 0, 4);
                    cons.gridy = i;
                    cons.gridwidth = 2;
                    break;
                }
                case 1: {
                    this.labels[i].setText(String.valueOf(Settings.getText("TAG_VERSION")) + " " + Settings.Default().VersionNumber);
                    this.labels[i].setFont(new Font("Arial", 0, 10));
                    cons.insets = new Insets(0, 12, 24, 4);
                    cons.gridy = i;
                    break;
                }
                case 2: {
                    this.labels[i].setText("eBesucher.de");
                    this.labels[i].setFont(new Font("Arial", 0, 13));
                    cons.insets = new Insets(12, 16, 0, 4);
                    cons.gridy = i;
                    break;
                }
                case 3: {
                    this.labels[i].setText("http://www.ebesucher.de");
                    this.labels[i].setFont(new Font("Arial", 1, 13));
                    this.labels[i].setForeground(Color.BLUE);
                    this.labels[i].addMouseListener(this);
                    this.labels[i].setCursor(new Cursor(12));
                    cons.insets = new Insets(0, 16, 0, 4);
                    cons.gridy = i;
                    break;
                }
                case 4: {
                    this.labels[i].setText(String.valueOf(Settings.getText("CREDITS_DEVELOPER")) + ": Peter Laske");
                    this.labels[i].setFont(new Font("Arial", 0, 13));
                    cons.insets = new Insets(32, 16, 0, 4);
                    cons.gridy = i;
                    break;
                }
                case 5: {
                    this.labels[i].setText("peter@ebesucher.de");
                    this.labels[i].setFont(new Font("Arial", 1, 13));
                    this.labels[i].setForeground(Color.BLUE);
                    this.labels[i].addMouseListener(this);
                    this.labels[i].setCursor(new Cursor(12));
                    cons.insets = new Insets(4, 70, 32, 4);
                    cons.gridy = i;
                    break;
                }
                case 6: {
                    this.labels[i].setText(String.valueOf(Settings.getText("CREDITS_SUPPORT")) + ": ");
                    this.labels[i].setFont(new Font("Arial", 0, 13));
                    cons.insets = new Insets(0, 16, 0, 0);
                    cons.gridy = i;
                    cons.gridwidth = 1;
                    break;
                }
                case 7: {
                    this.labels[i].setText("support@ebesucher.de");
                    this.labels[i].setFont(new Font("Arial", 1, 13));
                    this.labels[i].setForeground(Color.BLUE);
                    this.labels[i].addMouseListener(this);
                    this.labels[i].setCursor(new Cursor(12));
                    cons.insets = new Insets(0, 2, 16, 0);
                    cons.gridy = i;
                    cons.gridx = 1;
                }
            }
            this.layout.setConstraints(this.labels[i], cons);
            this.add(this.labels[i]);
            ++i;
        }
        this.eBesucherLogo = new ViewComponent("ebesucher.png", null, ViewComponent.ImageLayout.None);
        this.eBesucherLogo.setPosition(64, 0);
        cons.gridx = 2;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 4;
        cons.fill = 1;
        cons.insets = new Insets(10, 0, 0, 0);
        this.layout.addLayoutComponent(this.eBesucherLogo, cons);
        this.add(this.eBesucherLogo);
        this.zeraSothLogo = new ViewComponent("zeraSoth.png", null, ViewComponent.ImageLayout.None);
        cons.gridy = 4;
        this.zeraSothLogo.setPosition(64, 10);
        this.layout.addLayoutComponent(this.zeraSothLogo, cons);
        this.add(this.zeraSothLogo);
        this.closeButton = new JButton(Settings.getText("TAG_CLOSE"));
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("close");
        cons.gridy = this.labels.length + 1;
        cons.gridx = 0;
        cons.gridwidth = 3;
        cons.fill = 0;
        cons.anchor = 10;
        cons.weighty = 0.0;
        cons.weightx = 1.0;
        cons.insets = new Insets(2, 2, 2, 2);
        this.layout.setConstraints(this.closeButton, cons);
        this.add(this.closeButton);
        this.setResizable(false);
        this.setBounds(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - 225, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - 160, 450, 320);
        if (Settings.Default().OperatingSystem() == OS.WINDOWS) {
            this.setIconImage(Program.programImage);
        }
        this.setVisible(true);
    }
}

