/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import restarter.Program;
import restarter.Settings;
import restarter.enums.OS;

public class InfoPopUp
extends JDialog {
    private static final long serialVersionUID = 4713L;
    private Timer timer;
    private String headline;
    private String[] text;
    private GridBagLayout layout;
    private JLabel top;
    public JLabel[] bottomLabels;

    public InfoPopUp(JFrame owner, String headline, String[] text, int delay) {
        super(owner, Settings.getText("TAG_INFO"), false);
        this.headline = headline;
        this.text = text;
        this.Initialize();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new TimerWork(this), delay);
    }

    public void CloseWindow() {
        this.timer.cancel();
        this.setVisible(false);
        this.dispose();
    }

    private void Initialize() {
        GridBagConstraints cons = new GridBagConstraints();
        this.setContentPane(new BackGroundPane("PopUpBack.png"));
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.top = new JLabel(this.headline);
        this.top.setFont(new Font("Arial", 1, 16));
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.fill = 1;
        this.layout.setConstraints(this.top, cons);
        this.add(this.top);
        this.bottomLabels = new JLabel[this.text.length];
        cons.insets = new Insets(0, 4, 0, 4);
        int i = 0;
        while (i < this.text.length) {
            if (i == this.text.length - 1) {
                cons.insets = new Insets(0, 4, 4, 4);
            }
            cons.gridy = i + 1;
            this.bottomLabels[i] = new JLabel(this.text[i]);
            this.bottomLabels[i].setFont(new Font("Arial", 0, 13));
            this.layout.setConstraints(this.bottomLabels[i], cons);
            this.add(this.bottomLabels[i]);
            ++i;
        }
        this.setUndecorated(true);
        this.pack();
        this.setBounds(Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth(), Toolkit.getDefaultToolkit().getScreenSize().height - this.getHeight() - (Settings.Default().OperatingSystem() == OS.WINDOWS ? 30 : 0), this.getWidth(), this.getHeight());
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    class BackGroundPane
    extends JPanel {
        private static final long serialVersionUID = 4714L;
        Image img = null;

        BackGroundPane(String imagefile) {
            if (imagefile != null) {
                MediaTracker mt = new MediaTracker(this);
                this.img = Toolkit.getDefaultToolkit().getImage(Program.class.getResource(imagefile));
                mt.addImage(this.img, 0);
                try {
                    mt.waitForAll();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.img, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }

    class TimerWork
    extends TimerTask {
        private InfoPopUp dialog;

        public TimerWork(InfoPopUp dialog) {
            this.dialog = dialog;
        }

        @Override
        public void run() {
            this.dialog.CloseWindow();
        }
    }
}

