/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import restarter.PopUpTimerTask;
import restarter.Program;
import restarter.ServerWork;
import restarter.Settings;
import restarter.enums.OS;

public class LogInForm
extends JDialog
implements ActionListener,
KeyListener,
MouseListener {
    private static final Logger logger = Logger.getLogger(LogInForm.class.getName());
    private static final long serialVersionUID = 4711L;
    public static int RESULT;
    private GridBagLayout layout;
    private JLabel topLabel;
    private JLabel topLabel2;
    private JLabel userLabel;
    private JLabel passwordLabel;
    private JLabel restarterLinkLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField passwordTextfield;
    private JTextField userTextfield;
    private JButton getCodeButton;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    public LogInForm(JFrame owner) {
        super(owner, Settings.Default().Language.getProperty("TAG_REGISTER"), true);
        logger.info("create");
        this.InitializeComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                RESULT = -1;
                LogInForm.this.ExitProgram();
            }
        });
    }

    public void ExitProgram() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String s = event.getActionCommand();
        if (s.equals("OK")) {
            this.closeAndSave();
        } else if (s.equals("Cancel")) {
            logger.info("abort");
            RESULT = -1;
            this.ExitProgram();
        } else if (s.equals("getCode")) {
            logger.info("open link to code: http://www.ebesucher.de/restarter.html");
            PopUpTimerTask.StartBrowser("http://www." + Settings.Default().Domain + "." + Settings.Default().getTopLevelDomain() + "/restarter.html");
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.getComponent();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void closeAndSave() {
        ServerWork.LoginResults res = ServerWork.LogInIsOK(this.userTextfield.getText(), this.passwordTextfield.getText());
        if (res == ServerWork.LoginResults.WRONG) {
            this.topLabel2.setText(Settings.Default().Language.getProperty("LOGIN_WRONGDATA"));
            this.topLabel2.setForeground(Color.RED);
            return;
        }
        if (res == ServerWork.LoginResults.NO_INTERNET_ACCESS) {
            this.topLabel2.setText(Settings.Default().Language.getProperty("LOGIN_NOINTERNETACCESS"));
            this.topLabel2.setForeground(Color.RED);
            return;
        }
        logger.info("login acepted");
        Settings.Default().SetAccount(this.userTextfield.getText(), this.passwordTextfield.getText());
        Settings.Default().SaveData();
        RESULT = 0;
        this.ExitProgram();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 10) {
            this.closeAndSave();
        }
    }

    private void InitializeComponents() {
        GridBagConstraints cons = new GridBagConstraints();
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.topLabel = new JLabel();
        this.topLabel.setText(Settings.Default().Language.getProperty("LOGIN_HEAD"));
        cons = new GridBagConstraints();
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 5;
        cons.gridheight = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.insets = new Insets(4, 4, 1, 4);
        this.layout.setConstraints(this.topLabel, cons);
        this.add(this.topLabel);
        this.topLabel2 = new JLabel();
        this.topLabel2.setText(Settings.Default().Language.getProperty("LOGIN_NOTACCOUNTPASSWORD"));
        cons.gridy = 1;
        cons.insets = new Insets(1, 4, 1, 4);
        this.layout.setConstraints(this.topLabel2, cons);
        this.add(this.topLabel2);
        this.userLabel = new JLabel();
        this.userLabel.setText(Settings.Default().Language.getProperty("LOGIN_USER"));
        cons.gridy = 2;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        this.layout.setConstraints(this.userLabel, cons);
        this.add(this.userLabel);
        this.passwordLabel = new JLabel();
        this.passwordLabel.setText(Settings.Default().Language.getProperty("LOGIN_CODE"));
        cons.gridy = 3;
        this.layout.setConstraints(this.passwordLabel, cons);
        this.add(this.passwordLabel);
        this.restarterLinkLabel = new JLabel();
        this.restarterLinkLabel.setText(Settings.Default().Language.getProperty("LOGIN_GOTOHOMEPAGE"));
        this.restarterLinkLabel.addMouseListener(this);
        this.userTextfield = new JTextField();
        this.userTextfield.setText(Settings.Default().getUser());
        this.userTextfield.addKeyListener(this);
        cons.gridx = 1;
        cons.gridy = 2;
        cons.gridwidth = 4;
        cons.weightx = 1.0;
        this.layout.setConstraints(this.userTextfield, cons);
        this.add(this.userTextfield);
        this.passwordTextfield = new JTextField();
        this.passwordTextfield.setText(Settings.Default().getPassword());
        this.passwordTextfield.addKeyListener(this);
        cons.gridy = 3;
        this.layout.setConstraints(this.passwordTextfield, cons);
        this.add(this.passwordTextfield);
        this.getCodeButton = new JButton();
        this.getCodeButton.setText(Settings.Default().Language.getProperty("LOGIN_GETCODE"));
        this.getCodeButton.setActionCommand("getCode");
        this.getCodeButton.addActionListener(this);
        cons.fill = 10;
        cons.gridx = 2;
        cons.gridy = 4;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.insets = new Insets(6, 0, 4, 4);
        this.layout.setConstraints(this.getCodeButton, cons);
        this.add(this.getCodeButton);
        this.okButton = new JButton(Settings.Default().Language.getProperty("TAG_SAVE"));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        cons.fill = 1;
        cons.gridx = 3;
        cons.insets = new Insets(6, 1, 4, 1);
        this.layout.setConstraints(this.okButton, cons);
        this.add(this.okButton);
        this.cancelButton = new JButton(Settings.Default().Language.getProperty("TAG_ABORT"));
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        cons.fill = 1;
        cons.gridx = 4;
        cons.insets = new Insets(6, 1, 4, 10);
        this.layout.setConstraints(this.cancelButton, cons);
        this.add(this.cancelButton);
        this.layout.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0};
        if (Settings.Default().OperatingSystem() == OS.WINDOWS) {
            this.setIconImage(Program.programImage);
        }
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.pack();
        this.setBounds(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.setVisible(true);
    }
}

