/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import restarter.PopUpTimerTask;
import restarter.Program;
import restarter.Settings;
import restarter.ViewComponent;
import restarter.enums.RunningStates;
import restarter.forms.CreditsForm;
import restarter.forms.OptionsForm;

public class MenuForm
extends JFrame
implements ActionListener {
    private static final Logger logger = Logger.getLogger(MenuForm.class.getName());
    private static final long serialVersionUID = 4712L;
    private GridBagLayout layout;
    private JButton infoButton;
    private JButton startButton;
    private JButton stopButton;
    private JButton closeButton;
    private JCheckBox hideCheckBox;
    private JButton settingsButton;
    private JButton homepageButton;
    private JButton creditsButton;
    private ViewComponent statusPicture;
    private JLabel creditLabel;
    private JLabel infoLabel;
    public JTextArea counterLabel;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    public MenuForm(int x, int y) {
        super(Settings.Default().ProductName);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MenuForm.this.ExitProgram();
            }
        });
        this.Initialize();
        this.setBounds(x, y, this.getWidth(), this.getHeight());
        logger.info("created");
    }

    private void ExitProgram() {
        Settings.Default().menuFormLeft = this.getX();
        Settings.Default().menuFormTop = this.getY();
        Settings.Default().ShowMenuForm(this.isVisible());
        Settings.Default().SaveData();
        this.setVisible(false);
        this.dispose();
        logger.info("close program");
        System.exit(0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String s = event.getActionCommand();
        if (s.equals("infoForm")) {
            logger.info("open link: http://wiki.ebesucher.de/Tools/Restarter");
            PopUpTimerTask.StartBrowser("http://wiki." + Settings.Default().Domain + ".de/Tools/Restarter");
        } else if (s.equals("start")) {
            this.SetProgramWorkState(RunningStates.RUNNING);
            Program.StartTimer(30);
        } else if (s.equals("stop")) {
            this.SetProgramWorkState(RunningStates.STOPPED);
            Program.StopTimer();
        } else if (s.equals("settings")) {
            new OptionsForm(this);
            this.setTexts();
        } else if (s.equals("homepage")) {
            PopUpTimerTask.StartBrowser(true);
        } else if (s.equals("credits")) {
            new CreditsForm(this);
        } else if (s.equals("close")) {
            this.ExitProgram();
        } else if (s.equals("hide")) {
            if (Program.useTray) {
                Settings.Default().hideMenuForm = this.hideCheckBox.isSelected();
                this.setVisible(!this.hideCheckBox.isSelected());
                if (this.isVisible()) {
                    logger.info("hide window");
                } else {
                    logger.info("show window");
                }
            } else {
                this.hideCheckBox.setEnabled(false);
                logger.info("can't hide window: tray is disabled");
            }
        }
    }

    public void Show() {
        this.hideCheckBox.setSelected(false);
        this.setVisible(true);
        logger.info("show window");
    }

    public void SetProgramWorkState(RunningStates state) {
        logger.info("set work state: " + (Object)((Object)state));
        this.startButton.setEnabled(state == RunningStates.STOPPED);
        this.stopButton.setEnabled(state != RunningStates.STOPPED);
        Program.runningState = state;
        if (state == RunningStates.RUNNING) {
            this.statusPicture.setImage(1);
        } else if (state == RunningStates.CHECKING) {
            this.statusPicture.setImage(2);
        } else if (state == RunningStates.RESTARTING) {
            this.statusPicture.setImage(3);
        } else if (state == RunningStates.NOCONNECTION) {
            this.statusPicture.setImage(4);
        } else if (state == RunningStates.STOPPED) {
            this.statusPicture.setImage(0);
            this.counterLabel.setText(Settings.getText("TAG_DISABLED"));
        }
    }

    public void ShowStatePicture(boolean show) {
        this.statusPicture.setVisible(show);
        this.infoLabel.setVisible(show);
        this.counterLabel.setVisible(show);
        Settings.Default().showStatePicture = show;
        if (show) {
            logger.info("show state picture");
        } else {
            logger.info("hide state picture");
        }
    }

    private void Initialize() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        GridBagConstraints cons = new GridBagConstraints();
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.startButton = new JButton();
        this.startButton.setEnabled(!Program.isWorking());
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        cons = new GridBagConstraints();
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 2;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.insets = new Insets(4, 4, 0, 4);
        this.layout.setConstraints(this.startButton, cons);
        this.add(this.startButton);
        this.stopButton = new JButton();
        this.stopButton.setEnabled(Program.isWorking());
        this.stopButton.setActionCommand("stop");
        this.stopButton.addActionListener(this);
        cons.gridy = 1;
        cons.insets.top = 1;
        this.layout.setConstraints(this.stopButton, cons);
        this.add(this.stopButton);
        this.settingsButton = new JButton();
        this.settingsButton.setActionCommand("settings");
        this.settingsButton.addActionListener(this);
        cons.gridy = 2;
        cons.insets.top = 4;
        this.layout.setConstraints(this.settingsButton, cons);
        this.add(this.settingsButton);
        this.infoButton = new JButton();
        this.infoButton.setActionCommand("infoForm");
        this.infoButton.addActionListener(this);
        cons.gridy = 3;
        cons.insets.top = 1;
        this.layout.setConstraints(this.infoButton, cons);
        this.add(this.infoButton);
        this.homepageButton = new JButton();
        this.homepageButton.setActionCommand("homepage");
        this.homepageButton.addActionListener(this);
        cons.gridy = 4;
        cons.weightx = 0.0;
        this.layout.setConstraints(this.homepageButton, cons);
        this.add(this.homepageButton);
        this.creditsButton = new JButton();
        this.creditsButton.setActionCommand("credits");
        this.creditsButton.addActionListener(this);
        cons.gridy = 5;
        cons.weightx = 0.0;
        this.layout.setConstraints(this.creditsButton, cons);
        this.add(this.creditsButton);
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(this);
        cons.gridx = 0;
        cons.gridy = 6;
        cons.gridwidth = 2;
        cons.insets.left = 4;
        cons.insets.top = 4;
        this.layout.setConstraints(this.closeButton, cons);
        this.add(this.closeButton);
        this.hideCheckBox = new JCheckBox();
        this.hideCheckBox.setEnabled(Program.useTray);
        this.hideCheckBox.addActionListener(this);
        this.hideCheckBox.setActionCommand("hide");
        this.hideCheckBox.setSelected(Settings.Default().hideMenuForm);
        this.hideCheckBox.setVisible(true);
        cons.gridwidth = 2;
        cons.gridx = 0;
        cons.gridy = 8;
        cons.weightx = 0.0;
        this.layout.setConstraints(this.hideCheckBox, cons);
        this.add(this.hideCheckBox);
        JLabel sl = new JLabel("                                                ");
        cons.gridx = 2;
        this.layout.setConstraints(sl, cons);
        this.add(sl);
        this.infoLabel = new JLabel();
        this.infoLabel.setFont(new Font("Arial", 1, 11));
        cons.gridwidth = 3;
        cons.gridx = 2;
        cons.gridy = 6;
        cons.insets = new Insets(0, 8, 0, 8);
        this.layout.setConstraints(this.infoLabel, cons);
        this.add(this.infoLabel);
        this.counterLabel = new JTextArea();
        this.counterLabel.setOpaque(false);
        this.counterLabel.setEditable(false);
        this.counterLabel.setLineWrap(true);
        this.counterLabel.setWrapStyleWord(true);
        this.counterLabel.setFont(new Font("Arial", 0, 10));
        cons.gridwidth = 3;
        cons.gridx = 2;
        cons.gridy = 7;
        cons.gridheight = 2;
        cons.insets = new Insets(0, 12, 2, 2);
        this.layout.setConstraints(this.counterLabel, cons);
        this.add(this.counterLabel);
        this.creditLabel = new JLabel();
        this.creditLabel.setText("\u00a9 eBesucher.de 2010 - 2011");
        cons.gridwidth = 2;
        cons.gridx = 0;
        cons.gridy = 7;
        cons.gridheight = 1;
        cons.fill = 15;
        cons.anchor = 10;
        cons.insets = new Insets(0, 4, 0, 0);
        this.layout.setConstraints(this.creditLabel, cons);
        this.add(this.creditLabel);
        this.statusPicture = new ViewComponent("RedLogo.png", Settings.getText("STATE_RED"), ViewComponent.ImageLayout.Squared);
        this.statusPicture.addImage("GreenLogo.png", Settings.getText("STATE_GREEN"));
        this.statusPicture.addImage("GreenLogo.png", Settings.getText("RESTART_CHECK"));
        this.statusPicture.addImage("YellowLogo.png", Settings.getText("STATE_YELLOW"));
        this.statusPicture.addImage("NoConnectionYellowLogo.png", Settings.getText("STATE_NOCONNECTION"));
        this.statusPicture.setVisible(Settings.Default().showStatePicture);
        this.statusPicture.setPosition(0, 0);
        cons.gridx = 2;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 6;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.fill = 1;
        cons.anchor = 13;
        cons.insets = new Insets(4, 10, 0, 8);
        this.layout.setConstraints(this.statusPicture, cons);
        this.add(this.statusPicture);
        this.layout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        this.setTexts();
        this.setVisible(!Settings.Default().hideMenuForm);
        this.setAlwaysOnTop(Settings.Default().alwaysOnTop);
        this.setResizable(false);
        this.setIconImage(Program.programImage);
        this.pack();
        this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    private void setTexts() {
        this.startButton.setText(Settings.getText("TAG_START"));
        this.stopButton.setText(Settings.getText("TAG_STOP"));
        this.settingsButton.setText(String.valueOf(Settings.getText("TAG_SETTINGS")) + "...");
        this.infoButton.setText(String.valueOf(Settings.getText("TAG_FUNCTION")) + "...");
        this.homepageButton.setText(Settings.getText("TAG_STARTSURFBAR"));
        this.creditsButton.setText(String.valueOf(Settings.getText("TAG_ABOUT")) + "...");
        this.closeButton.setText(Settings.getText("TAG_EXIT"));
        this.hideCheckBox.setText(Settings.getText("TAG_HIDE"));
        this.infoLabel.setText(String.valueOf(Settings.getText("TAG_CURRENTACTION")) + ":");
        this.counterLabel.setText(Settings.getText("TAG_DISABLED"));
        ArrayList<String> pictureTexts = this.statusPicture.getTexts();
        pictureTexts.clear();
        pictureTexts.add(Settings.getText("STATE_RED"));
        pictureTexts.add(Settings.getText("STATE_GREEN"));
        pictureTexts.add(Settings.getText("RESTART_CHECK"));
        pictureTexts.add(Settings.getText("STATE_YELLOW"));
        pictureTexts.add(Settings.getText("STATE_NOCONNECTION"));
        this.statusPicture.setImage(this.statusPicture.getImageIndex());
        this.pack();
    }
}

