/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import restarter.Program;
import restarter.ServerWork;
import restarter.Settings;
import restarter.enums.OS;
import restarter.forms.BrowserPanel;
import restarter.forms.ChooseDomainPanel;
import restarter.forms.ChooseLanguagePanel;
import restarter.forms.LoginPanel;

public class OptionsForm
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4713L;
    private static final Logger logger = Logger.getLogger(OptionsForm.class.getName());
    public static int RESULT;
    private static JProgressBar progressBar;
    private GridBagLayout layout;
    private GridBagLayout restartPanelLayout;
    private GridBagLayout globalPanelLayout;
    private JTabbedPane tab;
    private BrowserPanel browserPanel;
    private JPanel restartPanel;
    private LoginPanel loginPanel;
    private JPanel globalPanel;
    private JButton OKButton;
    private JButton CancelButton;
    private JLabel infoLabel;
    private JCheckBox rEmulateEnterCheckBox;
    private JCheckBox rStartWithLinkCheckBox;
    private JCheckBox rRestartBrowserCheckBox;
    private JCheckBox rShowPopUpCheckBox;
    private JLabel rAtBrowserStartLabel;
    private JLabel rAtBrowserCrash;
    private JLabel rEmulateEnterLabel;
    private JLabel rEmulateEnterLabel2;
    private JCheckBox gAutoStartCheckBox;
    private JCheckBox gAlwaysOnTopCheckBox;
    private JCheckBox gShowStatePicture;
    private JLabel rTimeToEmulateEnterLabel;
    private JTextField rTimeToEmulateEnterTextBox;
    private ChooseLanguagePanel languagePanel;
    private ChooseDomainPanel domainPanel;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    public static void setSaveState(int state) {
        if (progressBar != null) {
            progressBar.setValue(state);
        }
    }

    public OptionsForm(JFrame owner) {
        super(owner, Settings.getText("TAG_SETTINGS"), true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                RESULT = -1;
                OptionsForm.this.ExitProgram();
            }
        });
        this.Initialize();
        logger.info("opened option window");
    }

    public void ExitProgram() {
        if (Settings.Default().getBrowsers != null && Settings.Default().getBrowsers.isAlive()) {
            Settings.Default().getBrowsers.RemoveSettingsWindow();
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String s = event.getActionCommand();
        if (!s.equals("showPopUp")) {
            if (s.equals("restartBrowser")) {
                this.rStartWithLinkCheckBox.setEnabled(this.rRestartBrowserCheckBox.isSelected());
                this.rEmulateEnterCheckBox.setEnabled(this.rRestartBrowserCheckBox.isSelected());
            } else if (!s.equals("startWithLink") && !s.equals("emulateEnter")) {
                if (s.equals("OK")) {
                    logger.info("begin saving changes");
                    progressBar = new JProgressBar();
                    progressBar.setMinimum(0);
                    progressBar.setMaximum(100);
                    progressBar.setValue(0);
                    progressBar.setOpaque(false);
                    GridBagLayout layout = new GridBagLayout();
                    GridBagConstraints cons = new GridBagConstraints();
                    cons.fill = 1;
                    cons.anchor = 10;
                    cons.gridheight = 1;
                    cons.gridwidth = 1;
                    cons.weightx = 1.0;
                    cons.weighty = 1.0;
                    cons.insets = new Insets(-4, -16, -4, -16);
                    cons.ipadx = 0;
                    cons.ipady = 0;
                    this.OKButton.setLayout(layout);
                    layout.setConstraints(progressBar, cons);
                    this.OKButton.add(progressBar);
                    this.OKButton.validate();
                    this.OKButton.setEnabled(false);
                    this.CancelButton.setEnabled(false);
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            OptionsForm.this.save();
                        }
                    });
                    thread.start();
                } else if (s.equals("cancel")) {
                    RESULT = -1;
                    this.ExitProgram();
                }
            }
        }
    }

    private void save() {
        ServerWork.LoginResults res = ServerWork.LogInIsOK(this.loginPanel.getLUserTextfield().getText(), this.loginPanel.getLPasswordTextfield().getText());
        OptionsForm.setSaveState(5);
        if (res == ServerWork.LoginResults.WRONG) {
            this.tab.setSelectedIndex(2);
            this.infoLabel.setText(Settings.getText("LOGIN_WRONGDATA"));
            progressBar.setVisible(false);
            this.OKButton.setEnabled(true);
            this.CancelButton.setEnabled(true);
            return;
        }
        if (res == ServerWork.LoginResults.NO_INTERNET_ACCESS) {
            this.tab.setSelectedIndex(2);
            this.infoLabel.setText(Settings.getText("LOGIN_NOINTERNETACCESS"));
            progressBar.setVisible(false);
            this.OKButton.setEnabled(true);
            this.CancelButton.setEnabled(true);
            return;
        }
        Settings.Default().SetAccount(this.loginPanel.getLUserTextfield().getText(), this.loginPanel.getLPasswordTextfield().getText());
        OptionsForm.setSaveState(8);
        if (this.browserPanel.getBIExplorer().isSelected()) {
            Settings.Default().setBrowser("iexplore");
        } else if (this.browserPanel.getBFirefox().isSelected()) {
            Settings.Default().setBrowser("firefox");
        } else if (this.browserPanel.getBChrome().isSelected()) {
            Settings.Default().setBrowser("chrome");
        } else if (this.browserPanel.getBOpera().isSelected()) {
            Settings.Default().setBrowser("opera");
        } else if (this.browserPanel.getBSafari().isSelected()) {
            Settings.Default().setBrowser("safari");
        } else if (this.browserPanel.getBOther().isSelected() && this.browserPanel.getBOtherTextField().getText().length() > 0 && Settings.Default().OperatingSystem() == OS.WINDOWS && new File(this.browserPanel.getBOtherTextField().getText()).exists()) {
            Settings.Default().setBrowser(this.browserPanel.getBOtherTextField().getText());
        } else if (this.browserPanel.getBOther().isSelected() && this.browserPanel.getBOtherTextField().getText().length() > 0 && Settings.Default().OperatingSystem() != OS.WINDOWS) {
            Settings.Default().setBrowser(this.browserPanel.getBOtherTextField().getText());
        } else {
            this.tab.setSelectedIndex(3);
            this.infoLabel.setText(Settings.getText("OPTIONS_INFOSETBROWSER"));
            logger.warning("saving aborted: no browser selected");
            return;
        }
        OptionsForm.setSaveState(9);
        try {
            Settings.Default().TimeToEmulateEnter = Integer.parseInt(this.rTimeToEmulateEnterTextBox.getText());
            if (Settings.Default().TimeToEmulateEnter < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.rTimeToEmulateEnterTextBox.setBackground(new Color(255, 128, 128));
            logger.warning("warong value for time to emulate enter");
            return;
        }
        OptionsForm.setSaveState(10);
        if (this.browserPanel.getBOtherTextField().getText().length() > 0) {
            Settings.Default().bOtherPath = this.browserPanel.getBOtherTextField().getText();
        }
        if (!this.browserPanel.getBOther().isSelected()) {
            Settings.Default().bOtherPath = "n/A";
        }
        Settings.Default().showPopUp = this.rShowPopUpCheckBox.isSelected();
        Settings.Default().restartBrowser = this.rRestartBrowserCheckBox.isSelected();
        Settings.Default().startWithLink = this.rStartWithLinkCheckBox.isSelected();
        Settings.Default().emulateEnter = this.rEmulateEnterCheckBox.isSelected();
        Settings.Default().autoStart = this.gAutoStartCheckBox.isSelected();
        Settings.Default().alwaysOnTop = this.gAlwaysOnTopCheckBox.isSelected();
        Program.menuForm.ShowStatePicture(this.gShowStatePicture.isSelected());
        Program.menuForm.setAlwaysOnTop(this.gAlwaysOnTopCheckBox.isSelected());
        Settings.Default().setTopLevelDomain(this.domainPanel.getSelectedDomainButtonGroup().getSelection().getActionCommand());
        OptionsForm.setSaveState(14);
        Settings.Default().SaveData();
        OptionsForm.setSaveState(18);
        this.languagePanel.Save();
        OptionsForm.setSaveState(100);
        RESULT = 0;
        this.ExitProgram();
        logger.info("saving done");
    }

    private void Initialize() {
        GridBagConstraints cons = new GridBagConstraints();
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.tab = new JTabbedPane();
        cons = new GridBagConstraints();
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 3;
        cons.gridheight = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.insets = new Insets(4, 4, 4, 4);
        this.layout.setConstraints(this.tab, cons);
        this.add(this.tab);
        this.infoLabel = new JLabel();
        this.infoLabel.setText("");
        this.infoLabel.setForeground(Color.RED);
        this.infoLabel.setFont(new Font("Arial", 1, 12));
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridx = 0;
        cons.gridy = 1;
        cons.insets = new Insets(8, 16, 4, 1);
        this.layout.setConstraints(this.infoLabel, cons);
        this.add(this.infoLabel);
        this.OKButton = new JButton(Settings.getText("TAG_SAVE"));
        this.OKButton.addActionListener(this);
        this.OKButton.setActionCommand("OK");
        cons.gridx = 1;
        cons.fill = 10;
        cons.insets = new Insets(12, 0, 4, 1);
        this.layout.setConstraints(this.OKButton, cons);
        this.add(this.OKButton);
        this.CancelButton = new JButton(Settings.getText("TAG_ABORT"));
        this.CancelButton.addActionListener(this);
        this.CancelButton.setActionCommand("cancel");
        cons.gridx = 2;
        cons.insets = new Insets(12, 1, 4, 4);
        this.layout.setConstraints(this.CancelButton, cons);
        this.layout.columnWeights = new double[]{1.0, 0.0, 0.0};
        this.add(this.CancelButton);
        this.globalPanel = new JPanel(this.globalPanelLayout);
        this.globalPanelLayout = new GridBagLayout();
        this.globalPanel.setLayout(this.globalPanelLayout);
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.insets = new Insets(2, 4, 2, 4);
        this.gAutoStartCheckBox = new JCheckBox(Settings.getText("OPTIONS_STARTWATCHIMMEDIALY"));
        this.gAutoStartCheckBox.addActionListener(this);
        this.gAutoStartCheckBox.setActionCommand("autostart");
        this.gAutoStartCheckBox.setSelected(Settings.Default().autoStart);
        this.globalPanelLayout.setConstraints(this.gAutoStartCheckBox, cons);
        this.globalPanel.add(this.gAutoStartCheckBox);
        this.gAlwaysOnTopCheckBox = new JCheckBox(Settings.getText("OPTIONS_ALWAYSONTOP"));
        this.gAlwaysOnTopCheckBox.addActionListener(this);
        this.gAlwaysOnTopCheckBox.setActionCommand("alwaysOnTop");
        this.gAlwaysOnTopCheckBox.setSelected(Settings.Default().alwaysOnTop);
        cons.gridy = 1;
        this.globalPanelLayout.setConstraints(this.gAlwaysOnTopCheckBox, cons);
        this.globalPanel.add(this.gAlwaysOnTopCheckBox);
        this.gShowStatePicture = new JCheckBox(Settings.getText("OPTIONS_SHOWSTATEPICTURE"));
        this.gShowStatePicture.addActionListener(this);
        this.gShowStatePicture.setActionCommand("showStatePicture");
        this.gShowStatePicture.setSelected(Settings.Default().showStatePicture);
        cons.gridy = 2;
        this.globalPanelLayout.setConstraints(this.gShowStatePicture, cons);
        this.globalPanel.add(this.gShowStatePicture);
        this.browserPanel = new BrowserPanel();
        this.domainPanel = new ChooseDomainPanel();
        this.layout = new GridBagLayout();
        this.loginPanel = new LoginPanel();
        this.restartPanel = new JPanel(this.restartPanelLayout);
        this.restartPanelLayout = new GridBagLayout();
        this.restartPanel.setLayout(this.restartPanelLayout);
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.weighty = 1.0;
        cons.insets = new Insets(2, 4, 2, 4);
        this.rAtBrowserCrash = new JLabel(Settings.getText("OPTIONS_ONBROWSERCRASH"));
        cons.gridy = 0;
        cons.gridwidth = 2;
        this.restartPanelLayout.setConstraints(this.rAtBrowserCrash, cons);
        this.restartPanel.add(this.rAtBrowserCrash);
        this.rShowPopUpCheckBox = new JCheckBox(Settings.getText("OPTIONS_SHOWMESSAGE"));
        cons.gridy = 1;
        this.rShowPopUpCheckBox.addActionListener(this);
        this.rShowPopUpCheckBox.setActionCommand("showPopUp");
        this.rShowPopUpCheckBox.setSelected(Settings.Default().showPopUp);
        this.restartPanelLayout.setConstraints(this.rShowPopUpCheckBox, cons);
        this.restartPanel.add(this.rShowPopUpCheckBox);
        this.rRestartBrowserCheckBox = new JCheckBox(Settings.getText("OPTIONS_RESTARTBROWSER"));
        this.rRestartBrowserCheckBox.addActionListener(this);
        this.rRestartBrowserCheckBox.setActionCommand("restartBrowser");
        this.rRestartBrowserCheckBox.setSelected(Settings.Default().restartBrowser);
        cons.gridy = 2;
        this.restartPanelLayout.setConstraints(this.rRestartBrowserCheckBox, cons);
        this.restartPanel.add(this.rRestartBrowserCheckBox);
        this.rAtBrowserStartLabel = new JLabel(Settings.getText("OPTIONS_ATBROWSERRESTART"));
        cons.gridy = 3;
        cons.insets = new Insets(4, 24, 4, 4);
        this.restartPanelLayout.setConstraints(this.rAtBrowserStartLabel, cons);
        this.restartPanel.add(this.rAtBrowserStartLabel);
        this.rStartWithLinkCheckBox = new JCheckBox(Settings.getText("OPTIONS_CALLSURFLINK"));
        this.rStartWithLinkCheckBox.addActionListener(this);
        this.rStartWithLinkCheckBox.setActionCommand("startWithLink");
        this.rStartWithLinkCheckBox.setEnabled(this.rRestartBrowserCheckBox.isSelected());
        this.rStartWithLinkCheckBox.setSelected(Settings.Default().startWithLink);
        cons.gridy = 4;
        cons.insets = new Insets(4, 24, 0, 4);
        this.restartPanelLayout.setConstraints(this.rStartWithLinkCheckBox, cons);
        this.rEmulateEnterCheckBox = new JCheckBox(Settings.getText("OPTIONS_EMULATEENTER"));
        this.rEmulateEnterCheckBox.addActionListener(this);
        this.rEmulateEnterCheckBox.setActionCommand("emulateEnter");
        this.rEmulateEnterCheckBox.setEnabled(this.rRestartBrowserCheckBox.isSelected());
        this.rEmulateEnterCheckBox.setSelected(Settings.Default().emulateEnter);
        cons.gridy = 6;
        cons.insets = new Insets(4, 24, 0, 4);
        this.restartPanelLayout.setConstraints(this.rEmulateEnterCheckBox, cons);
        this.restartPanel.add(this.rEmulateEnterCheckBox);
        this.rEmulateEnterLabel = new JLabel(Settings.getText("OPTIONS_MSGEMULATEENTER1"));
        this.rEmulateEnterLabel.setFont(new Font("Arial", 0, 11));
        cons.gridy = 7;
        cons.insets = new Insets(0, 44, 0, 4);
        this.restartPanelLayout.setConstraints(this.rEmulateEnterLabel, cons);
        this.restartPanel.add(this.rEmulateEnterLabel);
        this.rEmulateEnterLabel2 = new JLabel(Settings.getText("OPTIONS_MSGEMULATEENTER2"));
        this.rEmulateEnterLabel2.setFont(new Font("Arial", 0, 11));
        cons.gridy = 8;
        cons.insets = new Insets(0, 50, 4, 4);
        this.restartPanelLayout.setConstraints(this.rEmulateEnterLabel2, cons);
        this.restartPanel.add(this.rEmulateEnterLabel2);
        this.rTimeToEmulateEnterLabel = new JLabel(Settings.getText("OPTIONS_WAITFORENTER"));
        this.rTimeToEmulateEnterLabel.setFont(new Font("Arial", 0, 11));
        cons.gridy = 9;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 44, 0, 4);
        this.restartPanelLayout.setConstraints(this.rTimeToEmulateEnterLabel, cons);
        this.restartPanel.add(this.rTimeToEmulateEnterLabel);
        this.rTimeToEmulateEnterTextBox = new JTextField();
        this.rTimeToEmulateEnterTextBox.setText(String.valueOf(Settings.Default().TimeToEmulateEnter));
        cons.gridx = 1;
        cons.insets = new Insets(0, 0, 0, 0);
        this.restartPanelLayout.setConstraints(this.rTimeToEmulateEnterTextBox, cons);
        this.restartPanel.add(this.rTimeToEmulateEnterTextBox);
        this.languagePanel = new ChooseLanguagePanel();
        this.tab.addTab(Settings.getText("OPTIONS_TAB_USER"), this.loginPanel);
        this.tab.addTab(Settings.getText("OPTIONS_TAB_DOMAIN"), this.domainPanel);
        this.tab.addTab(Settings.getText("OPTIONS_TAB_BROWSER"), this.browserPanel);
        this.tab.addTab(Settings.getText("OPTIONS_TAB_GENERAL"), this.globalPanel);
        this.tab.addTab(Settings.getText("OPTIONS_TAB_WATCH"), this.restartPanel);
        this.tab.addTab(Settings.getText("LANGUAGE"), this.languagePanel);
        this.pack();
        this.setResizable(false);
        this.setBounds(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        if (Settings.Default().OperatingSystem() == OS.WINDOWS) {
            this.setIconImage(Program.programImage);
        }
        this.setVisible(true);
    }
}

