/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import restarter.Settings;
import restarter.enums.OS;

public class SelectOSForm
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6729152583613610966L;
    private GridBagLayout layout;
    private JComboBox comboBox;
    public OS os = OS.UNKNOWN;

    public SelectOSForm(JFrame owner, String detectedOS) {
        super(owner, Settings.getText("OS_CHOOSEOSTITLE"), true);
        System.out.print("Select Operation System");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SelectOSForm.this.ExitProgram();
            }
        });
        this.Initialize(detectedOS);
    }

    private void ExitProgram() {
        this.dispose();
        System.exit(0);
    }

    private void Initialize(String detectedOS) {
        GridBagConstraints cons = new GridBagConstraints();
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        JLabel upperLabel1 = new JLabel(Settings.getText("OS_COULDNTDETECTED"));
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 2;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.insets = new Insets(4, 4, 2, 4);
        this.layout.setConstraints(upperLabel1, cons);
        this.add(upperLabel1);
        JLabel upperLabel2 = new JLabel(String.valueOf(Settings.getText("OS_DETECT")) + ": " + detectedOS);
        cons.gridy = 1;
        cons.insets = new Insets(0, 4, 0, 4);
        this.layout.setConstraints(upperLabel2, cons);
        this.add(upperLabel2);
        JLabel upperLabel3 = new JLabel(Settings.getText("OS_CHOOSEOS"));
        cons.gridy = 2;
        cons.insets = new Insets(4, 4, 0, 4);
        this.layout.setConstraints(upperLabel3, cons);
        this.add(upperLabel3);
        this.comboBox = new JComboBox<String>(new String[]{"Windows", "Linux", "MacOS"});
        cons.gridy = 3;
        cons.insets = new Insets(0, 4, 4, 4);
        this.layout.setConstraints(this.comboBox, cons);
        this.add(this.comboBox);
        JButton okButton = new JButton(Settings.getText("TAG_OK"));
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        cons.fill = 10;
        cons.gridy = 4;
        cons.gridwidth = 1;
        cons.insets = new Insets(4, 4, 4, 4);
        this.layout.setConstraints(okButton, cons);
        this.add(okButton);
        JButton exitButton = new JButton(Settings.getText("TAG_EXIT"));
        exitButton.setActionCommand("EXIT");
        exitButton.addActionListener(this);
        cons.gridx = 1;
        cons.gridwidth = 1;
        this.layout.setConstraints(exitButton, cons);
        this.add(exitButton);
        this.pack();
        this.setAlwaysOnTop(true);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setLocation(x, y);
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String s = event.getActionCommand();
        if (s.equals("OK")) {
            if (this.comboBox.getSelectedItem() == "Windows") {
                this.os = OS.WINDOWS;
            } else if (this.comboBox.getSelectedItem() == "Linux") {
                this.os = OS.LINUX;
            } else if (this.comboBox.getSelectedItem() == "MacOS") {
                this.os = OS.MAC;
            }
            this.ExitWindow();
        } else if (s.equals("EXIT")) {
            this.ExitProgram();
        }
    }

    private void ExitWindow() {
        this.setVisible(false);
        this.dispose();
    }
}

