/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import restarter.PopUpTimerTask;
import restarter.Program;
import restarter.Settings;
import restarter.enums.RunningStates;
import restarter.forms.CreditsForm;
import restarter.forms.LogInForm;
import restarter.forms.OptionsForm;

public class TrayMenu
extends PopupMenu
implements ActionListener {
    private static final long serialVersionUID = 4716L;
    public Menu[] m = new Menu[3];

    public TrayMenu() {
        super("eBesucher Restarter");
        this.Initialize();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("ChangeUser")) {
            new LogInForm(Program.menuForm);
        } else if (event.getActionCommand().equals("Exit")) {
            Settings.Default().SaveData();
            System.exit(0);
        } else if (event.getActionCommand().equals("StartStop")) {
            if (Program.runningState == RunningStates.STOPPED) {
                Program.StartTimer(Settings.Default().timerDelay);
            } else {
                Program.StopTimer();
            }
        } else if (event.getActionCommand().equals("showWindow")) {
            Settings.Default().ShowMenuForm(true);
        } else if (event.getActionCommand().equals("settings")) {
            new OptionsForm(Program.menuForm);
        } else if (event.getActionCommand().equals("homepage")) {
            PopUpTimerTask.StartBrowser(true);
        } else if (event.getActionCommand().equals("credits")) {
            new CreditsForm(Program.menuForm);
        }
    }

    private void addNewMenuItem(Menu menu, String name, ActionListener listener, String actionCommand) {
        MenuItem mi = new MenuItem(name);
        mi.setActionCommand(actionCommand);
        mi.addActionListener(listener);
        menu.add(mi);
    }

    private void Initialize() {
        this.addNewMenuItem(this, Settings.getText("TAG_START"), this, "StartStop");
        this.addSeparator();
        this.addNewMenuItem(this, Settings.getText("TAG_SHOWMAINWINDOW"), this, "showWindow");
        this.addNewMenuItem(this, String.valueOf(Settings.getText("TAG_SETTINGS")) + "...", this, "settings");
        this.addNewMenuItem(this, String.valueOf(Settings.getText("LOGIN_SWITCHUSER")) + "...", this, "ChangeUser");
        this.addSeparator();
        this.addNewMenuItem(this, Settings.getText("TAG_STARTSURFBAR"), this, "homepage");
        this.addNewMenuItem(this, String.valueOf(Settings.getText("TAG_ABOUT")) + "...", this, "credits");
        this.addNewMenuItem(this, Settings.getText("TAG_EXIT"), this, "Exit");
    }
}

