/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import restarter.PopUpTimerTask;
import restarter.Program;
import restarter.ServerWork;
import restarter.Settings;
import restarter.forms.BrowserPanel;
import restarter.forms.ChooseDomainPanel;
import restarter.forms.ChooseLanguageForm;
import restarter.forms.LoginPanel;

public class WelcomeForm
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4718L;
    private static final Logger logger = Logger.getLogger(WelcomeForm.class.getName());
    private int actualStep = 0;
    public static int RESULT;
    private JPanel buttonPanel;
    private GridBagLayout buttonPanelLayout;
    private JButton nextButton;
    private JButton prevButton;
    private JButton cancelButton;
    private GridBagLayout layout;
    private JLabel headlineLabel;
    private JTextArea textBox;
    private JCheckBox checkBox;
    private BrowserPanel browserPanel;
    private LoginPanel loginPanel;
    private ChooseDomainPanel domainPanel;

    static {
        if (Program.fh != null) {
            logger.addHandler(Program.fh);
        }
    }

    public WelcomeForm(JFrame owner) {
        super(owner, Settings.getText("WELCOME"), true);
        new ChooseLanguageForm(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                RESULT = -1;
                WelcomeForm.this.ExitProgram(false);
            }
        });
        this.Initialize();
        this.SetStep(0);
    }

    private void ExitProgram() {
        this.setVisible(false);
        this.dispose();
    }

    private void ExitProgram(boolean save) {
        if (save) {
            Settings.Default().SaveData();
            RESULT = 0;
        } else {
            RESULT = -1;
        }
        this.ExitProgram();
    }

    public void Next() {
        switch (this.actualStep) {
            case 1: {
                Settings.Default().setTopLevelDomain(this.domainPanel.getSelectedDomainButtonGroup().getSelection().getActionCommand());
                break;
            }
            case 2: {
                ServerWork.LoginResults res = ServerWork.LogInIsOK(this.loginPanel.getLUserTextfield().getText(), this.loginPanel.getLPasswordTextfield().getText());
                if (res == ServerWork.LoginResults.WRONG) {
                    this.loginPanel.getLTopLabel().setForeground(Color.RED);
                    this.loginPanel.getLTopLabel().setText(Settings.getText("LOGIN_WRONGDATA"));
                    return;
                }
                if (res == ServerWork.LoginResults.NO_INTERNET_ACCESS) {
                    this.loginPanel.getLTopLabel().setForeground(Color.RED);
                    this.loginPanel.getLTopLabel().setText(Settings.getText("LOGIN_NOINTERNETACCESS"));
                    return;
                }
                Settings.Default().SetAccount(this.loginPanel.getLUserTextfield().getText(), this.loginPanel.getLPasswordTextfield().getText());
                break;
            }
            case 3: {
                if (this.browserPanel.getBIExplorer().isSelected()) {
                    Settings.Default().setBrowser("iexplore");
                    break;
                }
                if (this.browserPanel.getBFirefox().isSelected()) {
                    Settings.Default().setBrowser("firefox");
                    break;
                }
                if (this.browserPanel.getBOpera().isSelected()) {
                    Settings.Default().setBrowser("opera");
                    break;
                }
                if (this.browserPanel.getBChrome().isSelected()) {
                    Settings.Default().setBrowser("chrome");
                    break;
                }
                if (this.browserPanel.getBOther().isSelected() && this.browserPanel.getBOtherTextField().getText().length() > 0) {
                    Settings.Default().setBrowser(this.browserPanel.getBOtherTextField().getText());
                    break;
                }
                return;
            }
            case 4: {
                Settings.Default().emulateEnter = this.checkBox.isSelected();
            }
        }
        logger.info("go to next step [from " + this.actualStep + " to " + ++this.actualStep + "]");
        this.SetStep(this.actualStep);
    }

    public void Previous() {
        --this.actualStep;
        this.SetStep(this.actualStep);
        logger.info("go a step back. now in step: " + this.actualStep);
    }

    public void SetStep(int i) {
        this.actualStep = i;
        this.domainPanel.setVisible(false);
        this.loginPanel.setVisible(false);
        this.browserPanel.setVisible(false);
        this.checkBox.setVisible(false);
        this.nextButton.setText(Settings.getText("TAG_NEXT"));
        switch (i) {
            case 0: {
                this.headlineLabel.setText(String.valueOf(Settings.getText("WELCOME_STEP1TITLE")) + " " + Settings.Default().ProductName + "!");
                this.textBox.setText(Settings.getText("WELCOME_STEP1TEXT"));
                break;
            }
            case 1: {
                this.headlineLabel.setText(Settings.getText("WELCOME_STEP1_1TITLE"));
                this.textBox.setText(Settings.getText("WELCOME_STEP1_1TEXT"));
                this.domainPanel.setVisible(true);
                break;
            }
            case 2: {
                this.headlineLabel.setText(Settings.getText("WELCOME_STEP2TITLE"));
                this.textBox.setText(Settings.getText("WELCOME_STEP2TEXT"));
                this.loginPanel.setVisible(true);
                break;
            }
            case 3: {
                this.headlineLabel.setText(Settings.getText("WELCOME_STEP3TITLE"));
                this.textBox.setText(Settings.getText("WELCOME_STEP3TEXT"));
                this.browserPanel.setVisible(true);
                break;
            }
            case 4: {
                this.headlineLabel.setText(Settings.getText("WELCOME_STEP4TITLE"));
                this.textBox.setText(Settings.getText("WELCOME_STEP4TEXT"));
                this.checkBox.setText(Settings.getText("WELCOME_STEP4EMULATEENTER"));
                this.checkBox.setSelected(true);
                this.checkBox.setVisible(true);
                break;
            }
            case 5: {
                this.headlineLabel.setText(Settings.getText("WELCOME_STEP5TITLE"));
                this.textBox.setText(Settings.getText("WELCOME_STEP5TEXT"));
                this.nextButton.setText(Settings.getText("WELCOME_STEP5READY"));
                break;
            }
            case 6: {
                RESULT = 0;
                this.ExitProgram(true);
                break;
            }
        }
        this.prevButton.setEnabled(i > 0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String s = event.getActionCommand();
        if (s.equals("prev")) {
            this.Previous();
        } else if (s.equals("next")) {
            this.Next();
        } else if (s.equals("cancel")) {
            this.ExitProgram(false);
        } else if (s.equals("getCode")) {
            PopUpTimerTask.StartBrowser("http://www." + Settings.Default().Domain + "." + Settings.Default().getTopLevelDomain() + "/restarter.html");
        } else if (s.equals("BrowseOther")) {
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.getName().toLowerCase().endsWith(".exe");
                }

                @Override
                public String getDescription() {
                    return Settings.getText("TAG_PROGRAMS");
                }
            });
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showOpenDialog(this) == 0) {
                this.browserPanel.getBOtherTextField().setText(chooser.getSelectedFile().getPath());
            }
        } else {
            this.browserPanel.getBIExplorer().setSelected(s.equals("iexplore"));
            this.browserPanel.getBFirefox().setSelected(s.equals("firefox"));
            this.browserPanel.getBOpera().setSelected(s.equals("opera"));
            this.browserPanel.getBChrome().setSelected(s.equals("chrome"));
            this.browserPanel.getBOther().setSelected(false);
            this.browserPanel.getBBrowseOther().setEnabled(false);
            this.browserPanel.getBOtherTextField().setEditable(false);
            if (!(s.equals("iexplore") || s.equals("firefox") || s.equals("opera") || s.equals("chrome"))) {
                this.browserPanel.getBOther().setSelected(true);
                this.browserPanel.getBBrowseOther().setEnabled(true);
                this.browserPanel.getBOtherTextField().setEditable(true);
            }
        }
    }

    private void Initialize() {
        GridBagConstraints cons = new GridBagConstraints();
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        cons.fill = 1;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(12, 8, 4, 8);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        this.headlineLabel = new JLabel(String.valueOf(Settings.getText("WELCOME_STEP1TITLE")) + " " + Settings.Default().ProductName + "!");
        this.headlineLabel.setFont(new Font("Arial", 1, 16));
        this.layout.setConstraints(this.headlineLabel, cons);
        this.add(this.headlineLabel);
        this.textBox = new JTextArea();
        this.textBox.setText(Settings.getText("WELCOME_STEP1TEXT"));
        this.textBox.setEditable(false);
        this.textBox.setLineWrap(true);
        this.textBox.setWrapStyleWord(true);
        this.textBox.setFont(new Font("Arial", 0, 12));
        this.textBox.setOpaque(false);
        cons.gridy = 1;
        cons.weighty = 0.3;
        cons.gridheight = 1;
        this.layout.setConstraints(this.textBox, cons);
        this.add(this.textBox);
        this.browserPanel = new BrowserPanel();
        cons.gridx = 0;
        cons.weighty = 1.0;
        cons.weightx = 1.0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.fill = 1;
        cons.gridy = 2;
        this.browserPanel.setVisible(false);
        this.layout.setConstraints(this.browserPanel, cons);
        this.add(this.browserPanel);
        this.domainPanel = new ChooseDomainPanel();
        cons.gridx = 0;
        cons.weighty = 1.0;
        cons.weightx = 1.0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.fill = 1;
        cons.gridy = 2;
        this.domainPanel.setVisible(false);
        this.layout.setConstraints(this.domainPanel, cons);
        this.add(this.domainPanel);
        this.loginPanel = new LoginPanel();
        cons.gridx = 0;
        cons.weighty = 1.0;
        cons.weightx = 1.0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.fill = 1;
        cons.gridy = 2;
        this.loginPanel.setVisible(false);
        this.layout.setConstraints(this.loginPanel, cons);
        this.add(this.loginPanel);
        this.checkBox = new JCheckBox("");
        this.checkBox.addActionListener(this);
        this.checkBox.setActionCommand("checkBox");
        this.checkBox.setVisible(false);
        cons.gridy = 2;
        cons.insets = new Insets(4, 12, 4, 4);
        this.layout.setConstraints(this.checkBox, cons);
        this.add(this.checkBox);
        this.buttonPanel = new JPanel();
        this.buttonPanelLayout = new GridBagLayout();
        this.buttonPanel.setLayout(this.buttonPanelLayout);
        cons.fill = 17;
        this.prevButton = new JButton(Settings.getText("TAG_PREVIOUS"));
        this.prevButton.setEnabled(false);
        this.prevButton.setActionCommand("prev");
        this.prevButton.addActionListener(this);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridx = 1;
        cons.gridy = 0;
        cons.insets = new Insets(1, 1, 1, 1);
        this.buttonPanelLayout.setConstraints(this.prevButton, cons);
        this.buttonPanel.add(this.prevButton);
        this.nextButton = new JButton(Settings.getText("TAG_NEXT"));
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(this);
        cons.gridx = 2;
        cons.weightx = 0.0;
        cons.fill = 10;
        this.buttonPanelLayout.setConstraints(this.nextButton, cons);
        this.buttonPanel.add(this.nextButton);
        this.cancelButton = new JButton(Settings.getText("TAG_EXIT"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        cons.gridx = 3;
        this.buttonPanelLayout.setConstraints(this.cancelButton, cons);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanelLayout.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0};
        cons.gridx = 0;
        cons.gridy = 3;
        cons.weighty = 0.0;
        cons.weightx = 1.0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.fill = 1;
        cons.insets = new Insets(0, 0, 4, 4);
        this.layout.setConstraints(this.buttonPanel, cons);
        this.add(this.buttonPanel);
        this.setResizable(false);
        this.setBounds(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - 256, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - 200, 512, 400);
        this.setVisible(true);
        this.actualStep = 0;
    }
}

