/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import restarter.Settings;
import restarter.forms.swing.components.CheckBoxList;
import restarter.forms.swing.components.ImageButton;

public class WindowTools {
    public static Color defaultForegroundColor = Color.white;

    public static JButton createButton(GridBagLayout layout, GridBagConstraints cons, String text, String actionCommand, int anchor, int fill, int gridx, int gridy, int gridWidth, int gridHeight, float weightx, float weighty, Insets insets, Container addAt, ActionListener actionListener, String imageData) {
        boolean web = false;
        try {
            new URL(imageData);
            web = true;
        }
        catch (MalformedURLException e) {
            web = false;
        }
        JButton b = imageData == null || !web && !new File(imageData).exists() ? new JButton() : new ImageButton(imageData);
        b.setText(text);
        b.setActionCommand(actionCommand);
        b.addActionListener(actionListener);
        cons.anchor = anchor;
        cons.fill = fill;
        cons.gridwidth = gridWidth;
        cons.gridheight = gridHeight;
        cons.gridx = gridx;
        cons.gridy = gridy;
        cons.weightx = weightx;
        cons.weighty = weighty;
        cons.insets = insets;
        layout.setConstraints(b, cons);
        addAt.add(b);
        return b;
    }

    public static JTextField createTextfield(GridBagLayout layout, GridBagConstraints cons, int anchor, int fill, int gridx, int gridy, int gridWidth, int gridHeight, float weightx, float weighty, Insets insets, Container addAt) {
        JTextField t = new JTextField();
        cons.anchor = anchor;
        cons.fill = fill;
        cons.gridwidth = gridWidth;
        cons.gridheight = gridHeight;
        cons.gridx = gridx;
        cons.gridy = gridy;
        cons.weightx = weightx;
        cons.weighty = weighty;
        cons.insets = insets;
        layout.setConstraints(t, cons);
        addAt.add(t);
        return t;
    }

    public static JLabel createLabel(GridBagLayout layout, GridBagConstraints cons, String text, int anchor, int fill, int gridx, int gridy, int gridWidth, int gridHeight, float weightx, float weighty, Insets insets, Container addAt) {
        JLabel l = new JLabel();
        l.setText(text);
        l.setForeground(defaultForegroundColor);
        cons.anchor = anchor;
        cons.fill = fill;
        cons.gridwidth = gridWidth;
        cons.gridheight = gridHeight;
        cons.gridx = gridx;
        cons.gridy = gridy;
        cons.weightx = weightx;
        cons.weighty = weighty;
        cons.insets = insets;
        layout.setConstraints(l, cons);
        addAt.add(l);
        return l;
    }

    public static CheckBoxList createCheckListBox(GridBagLayout layout, GridBagConstraints cons, int anchor, int fill, int gridx, int gridy, int gridWidth, int gridHeight, float weightx, float weighty, Insets insets, Container addAt) {
        CheckBoxList cbl = new CheckBoxList();
        cons.anchor = anchor;
        cons.fill = fill;
        cons.gridwidth = gridWidth;
        cons.gridheight = gridHeight;
        cons.gridx = gridx;
        cons.gridy = gridy;
        cons.weightx = weightx;
        cons.weighty = weighty;
        cons.insets = insets;
        layout.setConstraints(cbl, cons);
        addAt.add(cbl);
        return cbl;
    }

    public static <T extends JComponent> T createComponent(T component, GridBagLayout layout, GridBagConstraints cons, int anchor, int fill, int gridx, int gridy, int gridWidth, int gridHeight, float weightx, float weighty, Insets insets, Container addAt) {
        cons.anchor = anchor;
        cons.fill = fill;
        cons.gridwidth = gridWidth;
        cons.gridheight = gridHeight;
        cons.gridx = gridx;
        cons.gridy = gridy;
        cons.weightx = weightx;
        cons.weighty = weighty;
        cons.insets = insets;
        layout.setConstraints(component, cons);
        addAt.add(component);
        return component;
    }

    public static JPanel createPanel(GridBagLayout layout, GridBagConstraints cons, int gridx, int gridy, int gridWidth, int gridHeight, float weightx, float weighty, Insets insets, Container addAt) {
        JPanel p = new JPanel(){
            private static final long serialVersionUID = -3964677651902551782L;

            @Override
            protected void paintComponent(Graphics g) {
                this.getParent().repaint();
            }
        };
        cons.anchor = 15;
        cons.fill = 1;
        cons.gridwidth = gridWidth;
        cons.gridheight = gridHeight;
        cons.gridx = gridx;
        cons.gridy = gridy;
        cons.weightx = weightx;
        cons.weighty = weighty;
        cons.insets = insets;
        layout.setConstraints(p, cons);
        addAt.add(p);
        p.setOpaque(true);
        return p;
    }

    public static JPanel OKCancelButtons(boolean leftSided, ActionListener listener, String image) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        WindowTools.createButton(layout, cons, Settings.getText("OK"), "ok", leftSided ? 18 : 12, 0, 0, 0, 1, 1, !leftSided ? 1 : 0, 0.0f, new Insets(2, 2, 2, 2), panel, listener, image);
        WindowTools.createButton(layout, cons, Settings.getText("Cancel"), "cancel", leftSided ? 18 : 12, 0, 1, 0, 1, 1, leftSided ? 1 : 0, 0.0f, new Insets(2, 2, 2, 2), panel, listener, image);
        return panel;
    }

    public static JPanel OKCancelApplyButtons(boolean leftSided, ActionListener listener, String image) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        WindowTools.createButton(layout, cons, Settings.getText("OK"), "ok", leftSided ? 18 : 12, 0, 0, 0, 1, 1, !leftSided ? 1 : 0, 0.0f, new Insets(2, 2, 2, 2), panel, listener, image);
        WindowTools.createButton(layout, cons, Settings.getText("CANCEL"), "cancel", leftSided ? 18 : 12, 0, 1, 0, 1, 1, 0.0f, 0.0f, new Insets(2, 2, 2, 2), panel, listener, image);
        WindowTools.createButton(layout, cons, Settings.getText("APPLY"), "apply", leftSided ? 18 : 12, 0, 2, 0, 1, 1, leftSided ? 1 : 0, 0.0f, new Insets(2, 2, 2, 2), panel, listener, image);
        return panel;
    }

    public static void setWindowSize(Window window, int width, int height, boolean center) {
        window.setSize(400, 300);
        if (center) {
            window.setBounds(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - window.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - window.getHeight() / 2, window.getWidth(), window.getHeight());
        }
    }
}

