/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms.swing.components;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ImageButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private Image bimage;
    private Image mouseOverImage;
    private Image mousePressedImage;
    private Image disabledImage;
    private STATE state;

    public ImageButton(String imageData) {
        String fileExtension = imageData.substring(imageData.lastIndexOf(46));
        this.state = STATE.NORMAL;
        this.bimage = new ImageIcon(imageData).getImage();
        this.mouseOverImage = new ImageIcon(imageData.replace(fileExtension, "_mo" + fileExtension)).getImage();
        this.mousePressedImage = new ImageIcon(imageData.replace(fileExtension, "_mp " + fileExtension)).getImage();
        this.disabledImage = new ImageIcon(imageData.replace(fileExtension, "_dis" + fileExtension)).getImage();
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.addMouseListener(this);
    }

    @Override
    protected void paintComponent(Graphics arg0) {
        this.getParent().repaint();
        switch (this.state) {
            case NORMAL: {
                arg0.drawImage(this.bimage, 0, 0, this.getWidth(), this.getHeight(), null);
                break;
            }
            case DISABLED: {
                arg0.drawImage(this.disabledImage, 0, 0, this.getWidth(), this.getHeight(), null);
                break;
            }
            case OVER: {
                arg0.drawImage(this.mouseOverImage, 0, 0, this.getWidth(), this.getHeight(), null);
                break;
            }
            case PRESSED: {
                arg0.drawImage(this.mousePressedImage, 0, 0, this.getWidth(), this.getHeight(), null);
                break;
            }
        }
        arg0.drawString(this.getText(), (int)((float)this.getWidth() * 0.17f), (int)((float)this.getHeight() * 0.7f));
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.state = b ? STATE.NORMAL : STATE.DISABLED;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.state != STATE.DISABLED) {
            this.state = STATE.OVER;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.state != STATE.DISABLED) {
            this.state = STATE.NORMAL;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.state != STATE.DISABLED) {
            this.state = STATE.PRESSED;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.state != STATE.DISABLED) {
            this.state = STATE.OVER;
        }
    }

    private static enum STATE {
        NORMAL,
        OVER,
        PRESSED,
        DISABLED;

    }
}

