/*
 * Decompiled with CFR 0.152.
 */
package restarter.forms.swing.components;

import java.awt.Point;
import java.util.Hashtable;
import javax.swing.table.AbstractTableModel;

public class SparseTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7986428861082524002L;
    private Hashtable<Point, Object> lookup;
    private final int rows;
    private final int columns;
    private final String[] headers;

    public SparseTableModel(int rows, String[] columnHeaders) {
        if (rows < 0 || columnHeaders == null) {
            throw new IllegalArgumentException("Invalid row count/columnHeaders");
        }
        this.rows = rows;
        this.columns = columnHeaders.length;
        this.headers = columnHeaders;
        this.lookup = new Hashtable();
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public String getColumnName(int column) {
        return this.headers[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.lookup.get(new Point(row, column));
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.rows < 0 || this.columns < 0) {
            throw new IllegalArgumentException("Invalid row/column setting");
        }
        if (row < this.rows && column < this.columns) {
            this.lookup.put(new Point(row, column), value);
        }
    }
}

